/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.common.service;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration(value="mobileApiGatewayConfiguration")
@ParametersAreNonnullByDefault
public class ApiGatewayConfiguration {
    @Bean(name={"mobileApiGatewayAuthInterceptor"})
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @Nonnull
    public ClientHttpRequestInterceptor authInterceptor(HttpServletRequest request) {
        return (apiGatewayRequest, body, execution) -> {
            this.copyHeader(request, apiGatewayRequest, "Authorization");
            this.copyHeader(request, apiGatewayRequest, "just-token");
            return execution.execute(apiGatewayRequest, body);
        };
    }

    private void copyHeader(HttpServletRequest fromRequest, HttpRequest toRequest, String header) {
        toRequest.getHeaders().add(header, fromRequest.getHeader(header));
    }

    @Bean(name={"mobileApiGatewayRestOperations"})
    @Nonnull
    public RestOperations apiRestOperations(@Qualifier(value="mobileApiGatewayAuthInterceptor") ClientHttpRequestInterceptor authInterceptor) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(authInterceptor);
        return restTemplate;
    }
}

