/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.app.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.mobile.api.app.model.App;
import de.justsoftware.mobile.api.theme.service.MobileThemeService;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.model.UserCoreAppConfig;
import de.justsoftware.onx.appswitcher.model.UserExternalAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.mobile.DesktopHistoryTokenResolverService;
import de.justsoftware.onx.mobile.model.ResolvedDesktopHistoryToken;
import de.justsoftware.onx.person.business.PersonSettingService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiAppService")
@ParametersAreNonnullByDefault
public class AppService {
    private static final Logger LOG = LoggerFactory.getLogger(AppService.class);
    private static final List<CoreApp> SUPPORTED_CORE_APPS = ImmutableList.of((Object)CoreApp.CONVERSATIONS, (Object)CoreApp.SOCIAL, (Object)CoreApp.DRIVE, (Object)CoreApp.TASKS, (Object)CoreApp.PEOPLE, (Object)CoreApp.NEWS, (Object)CoreApp.WIKI, (Object)CoreApp.SNOWBALL);
    private final AppConfigService _appConfigService;
    private final JucoObjectMapper _objectMapper;
    private final DesktopHistoryTokenResolverService _resolverService;
    private final MobileThemeService _themeService;
    private final PersonSettingService _personSettingService;

    @Autowired
    public AppService(AppConfigService appConfigService, DesktopHistoryTokenResolverService resolverService, JucoObjectMapper objectMapper, MobileThemeService themeService, PersonSettingService personSettingService) {
        this._appConfigService = appConfigService;
        this._objectMapper = objectMapper;
        this._resolverService = resolverService;
        this._themeService = themeService;
        this._personSettingService = personSettingService;
    }

    @Nonnull
    public ImmutableList<App> getUserApps(AuthorizationContext authContext) {
        ImmutableList availableAppConfigs = this._appConfigService.getAvailableAppConfigs(authContext);
        ImmutableSet<AppId> homeScreenApps = this.getHomeScreenApps((ImmutableList<UserAppConfig>)availableAppConfigs, authContext);
        ImmutableSet<AppId> forcedApps = this.getForcedApps((ImmutableList<UserAppConfig>)availableAppConfigs);
        ImmutableSet orderedAppIds = ImmutableSet.copyOf((Collection)Sets.union(homeScreenApps, forcedApps));
        return this.convertToApps((ImmutableSet<AppId>)orderedAppIds, (ImmutableList<UserAppConfig>)availableAppConfigs, authContext);
    }

    @Nonnull
    public Optional<String> getExternalAppIconUrl(String appId, AuthorizationContext authCtx) {
        return this._appConfigService.getAvailableAppConfigs(authCtx).stream().filter(userAppConfig -> userAppConfig.getAppId().getId().equals(appId)).filter(userAppConfig -> userAppConfig instanceof UserExternalAppConfig).map(userAppConfig -> (UserExternalAppConfig)userAppConfig).findAny().map(externalApp -> ImageUrlUtil.getCustomAppSwitcherLogoUrl((String)externalApp.getIcon()));
    }

    @Nonnull
    private ImmutableSet<AppId> getDefaultApps(ImmutableList<UserAppConfig> availableAppConfigs) {
        return (ImmutableSet)availableAppConfigs.stream().filter(availableApp -> availableApp.getInitialVisibility() != InitialVisibility.INVISIBLE).map(UserAppConfig::getAppId).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableList<App> convertToApps(ImmutableSet<AppId> orderedAppIds, ImmutableList<UserAppConfig> availableAppConfigs, AuthorizationContext authContext) {
        ImmutableMap availableAppConfigsById = Maps.uniqueIndex(availableAppConfigs, UserAppConfig::getAppId);
        return (ImmutableList)orderedAppIds.stream().map(arg_0 -> ((ImmutableMap)availableAppConfigsById).get(arg_0)).filter(Objects::nonNull).map(this.toApp(authContext)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private Function<UserAppConfig, App> toApp(AuthorizationContext authContext) {
        Map<AppId, String> defaultCoreAppColors = this._themeService.getThemeColors(authContext.getTenantId());
        return appConfig -> {
            if (appConfig instanceof UserCoreAppConfig) {
                UserCoreAppConfig coreAppConfig = (UserCoreAppConfig)appConfig;
                AppId appId = coreAppConfig.getAppId();
                CoreApp coreApp = CoreApp.byAppId((AppId)appId);
                boolean appSupported = coreApp != null && SUPPORTED_CORE_APPS.contains(coreApp);
                return appSupported ? new App(appId, coreAppConfig.getType(), coreAppConfig.getName(), (String)defaultCoreAppColors.get(appId), null, null, null) : null;
            }
            if (appConfig instanceof UserExternalAppConfig) {
                UserExternalAppConfig externalAppConfig = (UserExternalAppConfig)appConfig;
                return new App(externalAppConfig.getAppId(), externalAppConfig.getType(), externalAppConfig.getName(), externalAppConfig.getAppColor(), externalAppConfig.getUrl(), this.iconPath(externalAppConfig), this.getResolvedDesktopHistoryToken(externalAppConfig.getUrl(), (AuthorizationCheckContext)authContext));
            }
            return null;
        };
    }

    @Nullable
    private String getResolvedDesktopHistoryToken(@Nonnull String url, @Nonnull AuthorizationCheckContext authContext) {
        ResolvedDesktopHistoryToken resolvedDesktopHistoryToken = this._resolverService.resolveTokenFromUrl(url, authContext);
        return resolvedDesktopHistoryToken == ResolvedDesktopHistoryToken.INVALID ? null : this.toJsonString(resolvedDesktopHistoryToken);
    }

    @Nullable
    private String toJsonString(@Nonnull ResolvedDesktopHistoryToken token) {
        try {
            return this._objectMapper.writeValueAsString((Object)token);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serializing ResolvedDesktopHistoryToken to JSON", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private String iconPath(UserExternalAppConfig externalAppConfig) {
        String storageServerPath = ImageUrlUtil.getCustomAppSwitcherLogoUrl((String)externalAppConfig.getIcon());
        return storageServerPath.toLowerCase(Locale.ENGLISH).endsWith(".svg") ? "/toro/mobile/api/v1/apps/" + externalAppConfig.getAppId().getId() + "/icon" : storageServerPath;
    }

    @Nonnull
    private ImmutableSet<AppId> getForcedApps(ImmutableList<UserAppConfig> availableAppConfigs) {
        return (ImmutableSet)availableAppConfigs.stream().filter(app -> app.getInitialVisibility() == InitialVisibility.FORCED).map(UserAppConfig::getAppId).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<AppId> getHomeScreenApps(ImmutableList<UserAppConfig> availableAppConfigs, AuthorizationContext authCtx) {
        ImmutableSet<AppId> userConfiguredApps = (ImmutableSet<AppId>)this._personSettingService.getHomeScreenApps(authCtx.getUserId()).stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        return userConfiguredApps.isEmpty() ? this.getDefaultApps(availableAppConfigs) : userConfiguredApps;
    }
}

