/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.app.controller;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.app.model.App;
import de.justsoftware.mobile.api.app.service.AppIconApiGatewayService;
import de.justsoftware.mobile.api.app.service.AppService;
import de.justsoftware.mobile.api.common.utils.Responses;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/mobile/api/v1/apps"})
@Api(tags={"Apps"})
public class AppController {
    private final AppService _appService;
    private final AppIconApiGatewayService _appIconApiGatewayService;

    @Autowired
    public AppController(AppService appService, AppIconApiGatewayService appIconApiGatewayService) {
        this._appService = appService;
        this._appIconApiGatewayService = appIconApiGatewayService;
    }

    @GetMapping(value={"/"})
    @ApiOperation(value="Retrieve app configs for all apps the user has configured on his homescreen.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableList<App> getApps(@AuthorizedContext AuthorizationContext authContext) {
        return this._appService.getUserApps(authContext);
    }

    @GetMapping(value={"/{appId}/icon"}, produces={"*/*"})
    @ApiOperation(value="Retrieves the icon for the external app with the given ID. SVG will be converted into PNG.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ResponseEntity<Resource> getAppIcon(@PathVariable(value="appId") String appId, @AuthorizedContext AuthorizationContext authContext) {
        return this._appService.getExternalAppIconUrl(appId, authContext).map(iconUrl -> this._appIconApiGatewayService.appIcon((String)iconUrl)).orElse(Responses.notFound());
    }
}

