/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0003a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0001'\t\rI\u0003\u0001\u0015!\u0003N\u0011\u001d\u0019\u0006A1A\u0005\u0002QCa!\u0018\u0001!\u0002\u0013)\u0006b\u00020\u0001\u0001\u0004%\ta\u0018\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0011\u0019\u0001\b\u0001)Q\u0005A\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bBB=\u0001A\u0003%1\u000fC\u0004{\u0001\t\u0007I\u0011\u0001'\t\rm\u0004\u0001\u0015!\u0003N\u0011\u001da\bA1A\u0005\u0002uDq!a\u0005\u0001A\u0003%a\u0010C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0001\u0002\u0018!I\u0011q\u0004\u0001A\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003K\u0001\u0001\u0015)\u0003\u0002\u001a!I\u0011q\u0005\u0001A\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003S\u0001\u0001\u0019!C\u0001\u0003WA\u0001\"a\f\u0001A\u0003&\u0011\u0011\u0004\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\t)\u0004\u0001C\u0001\u0003gA\u0001\"a\u000e\u0001\u0005\u0004%\tA\u001d\u0005\b\u0003s\u0001\u0001\u0015!\u0003t\u0011%\tY\u0004\u0001a\u0001\n\u0003\ti\u0004C\u0005\u0002h\u0001\u0001\r\u0011\"\u0001\u0002j!A\u0011Q\u000e\u0001!B\u0013\ty\u0004C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005}\u0004\u0001\"\u0001\u0002r!I\u0011\u0011\u0011\u0001A\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000f\u0003\u0001\u0019!C\u0001\u0003\u0013C\u0001\"!$\u0001A\u0003&\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t\u0019\n\u0001C!\u0003#Cq!a+\u0001\t\u0003\n\t\nC\u0004\u00026\u0002!\t!!%\t\u000f\u0005}\u0006\u0001\"\u0001\u0002\u0012\"9\u00111\u0019\u0001\u0005\u0002\u0005E\u0005bBAd\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003\u0017\u0004A\u0011BAg\u0005=aun\u001a*fG>4XM]=UKN$(BA\u00193\u0003\u0019\u0019XM\u001d<fe*\t1'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0004CA\u001c;\u001b\u0005A$BA\u001d3\u0003\tQ8.\u0003\u0002<q\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001 \u0011\u0005}\u0002Q\"\u0001\u0019\u0002'I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013A\u0001T8oO\u0006!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002\nQC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7/\u0001\fsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:!\u0003U\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN,\u0012!\u0014\t\u0003\u0007:K!a\u0014#\u0003\u0007%sG/\u0001\fsKBd\u0017nY1GKR\u001c\u0007nV1ji6\u000b\u00070T:!\u0003Q\u0011X\r\u001d7jG\u00064U\r^2i\u001b&t')\u001f;fg\u0006)\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKN\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\u0002\u000f\r|gNZ5hgV\t\u0001\rE\u0002bI\u001al\u0011A\u0019\u0006\u0003G\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\t)'MA\u0002TKF\u0004\"aP4\n\u0005!\u0004$aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u00111N\u001c\t\u0003\u00072L!!\u001c#\u0003\tUs\u0017\u000e\u001e\u0005\b_6\t\t\u00111\u0001a\u0003\rAH%M\u0001\tG>tg-[4tA\u0005)Ao\u001c9jGV\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002w3\u0006!A.\u00198h\u0013\tAXO\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005q\bcA@\u0002\u00105\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004d_6lwN\u001c\u0006\u0004g\u0005\u001d!\u0002BA\u0005\u0003\u0017\ta!\u00199bG\",'BAA\u0007\u0003\ry'oZ\u0005\u0005\u0003#\t\tA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nqa]3sm\u0016\u0014\u0018'\u0006\u0002\u0002\u001aA\u0019q(a\u0007\n\u0007\u0005u\u0001GA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'/M0%KF$2a[A\u0012\u0011!yg#!AA\u0002\u0005e\u0011\u0001C:feZ,'/\r\u0011\u0002\u000fM,'O^3se\u0005Y1/\u001a:wKJ\u0014t\fJ3r)\rY\u0017Q\u0006\u0005\t_f\t\t\u00111\u0001\u0002\u001a\u0005A1/\u001a:wKJ\u0014\u0004%\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'F\u0001g\u00031\u0019wN\u001c4jOB\u0013x\u000e]:3\u0003\u001diWm]:bO\u0016\f\u0001\"\\3tg\u0006<W\rI\u0001\taJ|G-^2feV\u0011\u0011q\b\t\t\u0003\u0003\nI%!\u0014\u0002T5\u0011\u00111\t\u0006\u0005\u0003w\t)E\u0003\u0003\u0002H\u0005\u0015\u0011aB2mS\u0016tGo]\u0005\u0005\u0003\u0017\n\u0019EA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004i\u0006=\u0013bAA)k\n9\u0011J\u001c;fO\u0016\u0014\b\u0003BA+\u0003GrA!a\u0016\u0002`A\u0019\u0011\u0011\f#\u000e\u0005\u0005m#bAA/i\u00051AH]8pizJ1!!\u0019E\u0003\u0019\u0001&/\u001a3fM&\u0019\u00010!\u001a\u000b\u0007\u0005\u0005D)\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000fF\u0002l\u0003WB\u0001b\u001c\u0011\u0002\u0002\u0003\u0007\u0011qH\u0001\naJ|G-^2fe\u0002\nq\u0001[<GS2,\u0017'\u0006\u0002\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002zA\n1b\u00195fG.\u0004x.\u001b8ug&!\u0011QPA<\u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\u00069\u0001n\u001e$jY\u0016\u0014\u0014aB:feZ,'o]\u000b\u0003\u0003\u000b\u0003B!\u00193\u0002\u001a\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\rY\u00171\u0012\u0005\t_\u0016\n\t\u00111\u0001\u0002\u0006\u0006A1/\u001a:wKJ\u001c\b%\u0001\bva\u0012\fG/\u001a)s_\u0012,8-\u001a:\u0015\u0003-\fQa]3u+BD3\u0001KAL!\u0011\tI*a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b1!\u00199j\u0015\u0011\t\t+a)\u0002\u000f),\b/\u001b;fe*!\u0011QUA\u0006\u0003\u0015QWO\\5u\u0013\u0011\tI+a'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rI\u0013q\u0016\t\u0005\u00033\u000b\t,\u0003\u0003\u00024\u0006m%!C!gi\u0016\u0014X)Y2i\u0003)\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RD3AKA]!\u0011\tI*a/\n\t\u0005u\u00161\u0014\u0002\u0005)\u0016\u001cH/\u0001\u0017uKN$\bjV\"iK\u000e\\\u0007o\\5oi^KG\u000f\u001b$bS2,(/Z:TS:<G.\u001a'pON+w-\\3oi\"\u001a1&!/\u0002[Q,7\u000f\u001e%X\u0007\",7m\u001b9pS:$hj\u001c$bS2,(/Z:Nk2$\u0018\u000e\u001d7f\u0019><7+Z4nK:$8\u000fK\u0002-\u0003s\u000bq\u0006^3ti\";6\t[3dWB|\u0017N\u001c;XSRDg)Y5mkJ,7/T;mi&\u0004H.\u001a'pON+w-\\3oiND3!LA]\u00031\u0019XM\u001c3NKN\u001c\u0018mZ3t)\rY\u0017q\u001a\u0005\u0007\u0003#t\u0003\u0019A'\u0002\u00039\u0004")
public class LogRecoveryTest
extends ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), null);
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), null);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT);
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp() {
        void createServer_time;
        void createServer_config;
        Time time;
        void createServer_time2;
        Time time2;
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        })));
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time time4 = time3;
        KafkaConfig createServer_config2 = this.configProps1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var4_5 = null;
        Object var1_4 = null;
        Object var2_3 = null;
        time4 = null;
        this.server1_$eq(createServer_this.createServer(createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, false));
        Time time5 = time = Time.SYSTEM;
        time = null;
        Time time6 = time5;
        KafkaConfig kafkaConfig = this.configProps2();
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        Object var8_10 = null;
        Object var5_9 = null;
        kafkaConfig = null;
        time6 = null;
        this.server2_$eq(createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, false));
        this.servers_$eq((Seq<KafkaServer>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(this, numMessages)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.servers().foreach((Function1 & Serializable)x$2 -> {
            LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(x$2);
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        Assertions.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        Assertions.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        None$ none$;
        None$ none$2;
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        this.sendMessages(1);
        Thread.sleep(1000L);
        long l = 1L;
        this.server1().shutdown();
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$32 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long l2 = 30000L;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$6 = none$3;
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$32, l2, (Option<Object>)x$4, (Option<Object>)x$6);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0");
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$4(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l3) {
                Assertions.fail((String)"Server 1 is not able to join the ISR after restart");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        this.server2().shutdown();
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$7 = this.zkClient();
        String x$8 = this.topic();
        int x$9 = this.partitionId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long l5 = 30000L;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$12 = none$4;
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, l5, (Option<Object>)x$10, (Option<Object>)x$12);
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1");
        this.sendMessages(1);
        ++l;
        long l6 = 15000L;
        long l7 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(this.server2().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l6) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l6), l7));
        }
        this.servers().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(this, hw)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.servers().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        Assertions.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        Assertions.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        None$ none$;
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        this.sendMessages(2);
        long l = 2L;
        long l2 = 15000L;
        long l3 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(this.server2().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l2) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l2), l3));
        }
        this.server1().shutdown();
        this.server2().shutdown();
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long l4 = 30000L;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$6 = none$2;
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, l4, (Option<Object>)x$4, (Option<Object>)x$6);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        this.server1().startup();
        this.updateProducer();
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        this.sendMessages(2);
        l += 2L;
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$8(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l5) {
                Assertions.fail((String)"Failed to create replica in follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        long l7 = 15000L;
        long l8 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(this.server1().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l7) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l7), l8));
        }
        this.servers().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        Assertions.assertEquals((long)l, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    private void sendMessages(int n) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable)x$6 -> LogRecoveryTest.$anonfun$sendMessages$1(this, BoxesRunTime.unboxToInt((Object)x$6))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(LogRecoveryTest $this, long numMessages$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresSingleLogSegment$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ void $anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(KafkaServer x$2) {
        x$2.replicaManager().checkpointHighWatermarks();
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$4(LogRecoveryTest $this) {
        return ((Partition)$this.server2().replicaManager().onlinePartition($this.topicPartition()).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$5() {
        return "Server 1 is not able to join the ISR after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$7(LogRecoveryTest $this, LongRef hw$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$8() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(LogRecoveryTest $this, long hw$2) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$1(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$8(LogRecoveryTest $this) {
        return $this.server1().replicaManager().localLog($this.topicPartition()).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$9() {
        return "Failed to create replica in follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$10(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server1().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$11() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ Future $anonfun$sendMessages$1(LogRecoveryTest $this, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)$this.message()));
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.replicaFetchWaitMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), Integer.toString(this.replicaFetchMinBytes()));
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

