/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ZkMetadataCache;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004Y\u0001\u0001\u0007I\u0011A-\t\r}\u0003\u0001\u0015)\u0003<\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B)\t\u000f%\u0004!\u0019!C\u0001O\"1!\u000e\u0001Q\u0001\nECqa\u001b\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004m\u0001\u0001\u0006IA\u0019\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u00199\b\u0001)A\u0005_\"9\u0001\u0010\u0001b\u0001\n\u0003I\bB\u0002@\u0001A\u0003%!\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\ti\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\ty\u0002\u0001Q\u0001\n\u0005M\u0001\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011!\ti\u0004\u0001Q\u0001\n\u0005\u0015\u0002\"CA \u0001\u0001\u0007I\u0011AA!\u0011%\tI\u0006\u0001a\u0001\n\u0003\tY\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA\"\u0011%\t\t\u0007\u0001a\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\u0001\r\u0011\"\u0001\u0002n!A\u0011\u0011\u000f\u0001!B\u0013\t)\u0007C\u0006\u0002t\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0004bCAE\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017C1\"a$\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAV\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003k\u0003A\u0011AAJ\u0011\u001d\ty\f\u0001C\u0001\u0003'Cq!a1\u0001\t\u0003\t\u0019\nC\u0004\u0002H\u0002!\t!a%\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9!\u0011\u0001\u0001\u0005\n\t\r!!E%te\u0016C\b/\u001b:bi&|g\u000eV3ti*\u0011!fK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(/F\u0001<!\u0011a\u0014i\u0011+\u000e\u0003uR!AP \u0002\u000f5,H/\u00192mK*\u0011\u0001)M\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\">\u0005\ri\u0015\r\u001d\t\u0005a\u00113\u0015+\u0003\u0002Fc\t1A+\u001e9mKJ\u0002\"a\u0012(\u000f\u0005!c\u0005CA%2\u001b\u0005Q%BA&.\u0003\u0019a$o\\8u}%\u0011Q*M\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002NcA\u0011\u0001GU\u0005\u0003'F\u00121!\u00138u!\r)f+U\u0007\u0002\u007f%\u0011qk\u0010\u0002\u0004'\u0016\f\u0018!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%te~#S-\u001d\u000b\u00035v\u0003\"\u0001M.\n\u0005q\u000b$\u0001B+oSRDqAX\u0002\u0002\u0002\u0003\u00071(A\u0002yIE\n!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.S:sA\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\t!\r\u0005\u00021G&\u0011A-\r\u0002\u0005\u0019>tw-\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005\t\u0016A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002%1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r^\u0001\u0014Y\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fI\u0001\u0017Y\u0016\fG-\u001a:M_\u001eD\u0015n\u001a5XCR,'/\\1sW\u00069B.Z1eKJdun\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000eI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!Q\u000f^5m\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u000591m\u001c8gS\u001e\u001cX#\u0001>\u0011\u0007U36\u0010\u0005\u00029y&\u0011Q0\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIa]\u0001\u0005Y\u0006tw-C\u0002P\u0003\u000f\ta\u0001^8qS\u000e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007,\u0003\u0015)H/\u001b7t\u0013\u0011\ti\"a\u0006\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002&A!\u0011qEA\u001d\u001b\t\tIC\u0003\u0003\u0002\"\u0005-\"\u0002BA\u0017\u0003_\taaY8n[>t'b\u0001\u0017\u00022)!\u00111GA\u001b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qG\u0001\u0004_J<\u0017\u0002BA\u001e\u0003S\u0011q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005Mc\u0002BA$\u0003\u001frA!!\u0013\u0002N9\u0019\u0011*a\u0013\n\u00031J!AK\u0016\n\u0007\u0005E\u0013&\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002V\u0005]#!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002R%\n\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007i\u000bi\u0006\u0003\u0005_1\u0005\u0005\t\u0019AA\"\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA3!\rA\u0014qM\u0005\u0004\u0003SJ#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002[\u0003_B\u0001BX\u000e\u0002\u0002\u0003\u0007\u0011QM\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005y\u0011\r\u001c;fe&\u001b(/T1oC\u001e,'/\u0006\u0002\u0002xA!\u0011\u0011PAB\u001d\u0011\tY(a \u000f\t\u0005%\u0013QP\u0005\u0004\u00033Y\u0013\u0002BAA\u0003/\t\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005\u0015\u0015q\u0011\u0002\u0014\u001b>\u001c7.\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u0005\u0003\u0003\u000b9\"A\nbYR,'/S:s\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002[\u0003\u001bC\u0001B\u0018\u0010\u0002\u0002\u0003\u0007\u0011qO\u0001\u0011C2$XM]%te6\u000bg.Y4fe\u0002\nQa]3u+B$\u0012A\u0017\u0015\u0004A\u0005]\u0005\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u0004CBL'\u0002BAQ\u0003G\u000bqA[;qSR,'O\u0003\u0003\u0002&\u0006U\u0012!\u00026v]&$\u0018\u0002BAU\u00037\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0011\u00020B!\u0011\u0011TAY\u0013\u0011\t\u0019,a'\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u0015;vG.4u\u000e\u001c7po\u0016\u00148\u000fK\u0002#\u0003s\u0003B!!'\u0002<&!\u0011QXAN\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^%te\u0016C\b/\u001b:bi&|g.\u00134O_\u001a+Go\u00195SKF,Xm\u001d;NC\u0012,\u0007fA\u0012\u0002:\u0006\tC/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001cFn\\<G_2dwn^3sg\"\u001aA%!/\u0002KQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s\u0007\u0006,x\r\u001b;Va\u001a{G\u000e\\8xKJ\u001c\bfA\u0013\u0002:\u0006\u0001s-\u001a;QCJ$\u0018\u000e^5p]^KG\u000f[!mYJ+\u0007\u000f\\5dCNLe.S:s)1\ty-a7\u0002^\u0006\u0005\u0018Q^Ay!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkW\u000591\r\\;ti\u0016\u0014\u0018\u0002BAm\u0003'\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000b}4\u0003\u0019\u0001$\t\r\u0005}g\u00051\u0001R\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005=a\u00051\u0001\u0002dB!\u0011Q]Au\u001b\t\t9O\u0003\u0003\u0002\u001a\u0005-\u0012\u0002BAv\u0003O\u0014A\u0001V5nK\"1\u0011q\u001e\u0014A\u0002m\faaY8oM&<\u0007bBAzM\u0001\u0007\u0011Q_\u0001\tY>\u001c\u0017\r\u001c'pOB!\u0011q_A\u007f\u001b\t\tIPC\u0002\u0002|.\n1\u0001\\8h\u0013\u0011\ty0!?\u0003\u00071{w-A\u0004m_\u001elunY6\u0016\u0005\u0005U\b")
public class IsrExpirationTest {
    private scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;

    public scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.alterIsrManager_$eq(new TestUtils.MockAlterIsrManager());
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, null, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)new CachedConfigRepository(), (Option)None$.MODULE$));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId())), ((IterableOnceOps)this.configs().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()))).toSet(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, time.milliseconds(), 0L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils.tempDirectory(null, null)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogEndOffset())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogHighWatermark())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.replicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.quotaManager = null;
        this.replicaManager = null;
    }
}

