/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I2Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u00013!)\u0001\u0007\u0001C\u00013\t\u0011\"I]8lKJ4U-\u0019;ve\u0016\u001cH+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011\u0001C\u0001\ni\u0016\u001cH/R7qif$\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0001\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002$I\u00059!.\u001e9ji\u0016\u0014(BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\t\u0002\u0005)\u0016\u001cH/A\u0014uKN$\u0018J\\2p[B\fG/\u001b2jY&$\u0018.Z:Ek\u0016$v.\u00112tK:$h)Z1ukJ,\u0007FA\u0002\u001f\u00035\"Xm\u001d;J]\u000e|W\u000e]1uS\nLG.\u001b;jKN$U/\u001a+p\u0013:\u001cw.\u001c9bi&\u0014G.\u001a$fCR,(/\u001a\u0015\u0003\ty\ta\u0003^3ti\u000e{W\u000e]1uS\ndWMR3biV\u0014Xm\u001d\u0015\u0003\u000by\tA\u0004^3ti\u0012+g-Y;mi\u001aKg.\u00197ju\u0016$g)Z1ukJ,7\u000f\u000b\u0002\u0007=\u0001")
public class BrokerFeaturesTest {
    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.createDefault().supportedFeatures().empty());
    }

    @Test
    public void testIncompatibilitiesDueToAbsentFeature() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava());
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new FinalizedVersionRange(2, 3))}));
        scala.collection.immutable.Map inCompatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)new FinalizedVersionRange(3, 4))}));
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)compatibleFeatures.$plus$plus((IterableOnce)inCompatibleFeatures);
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)features).asJava());
        Assertions.assertEquals((Object)Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)inCompatibleFeatures).asJava()), (Object)brokerFeatures.incompatibleFeatures(finalizedFeatures));
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, finalizedFeatures));
    }

    @Test
    public void testIncompatibilitiesDueToIncompatibleFeature() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava());
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new FinalizedVersionRange(2, 3))}));
        scala.collection.immutable.Map inCompatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new FinalizedVersionRange(1, 4))}));
        scala.collection.immutable.Map features = (scala.collection.immutable.Map)compatibleFeatures.$plus$plus((IterableOnce)inCompatibleFeatures);
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)features).asJava());
        Assertions.assertEquals((Object)Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)inCompatibleFeatures).asJava()), (Object)brokerFeatures.incompatibleFeatures(finalizedFeatures));
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, finalizedFeatures));
    }

    @Test
    public void testCompatibleFeatures() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava());
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new FinalizedVersionRange(2, 3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new FinalizedVersionRange(1, 3))}));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)compatibleFeatures).asJava());
        Assertions.assertTrue((boolean)brokerFeatures.incompatibleFeatures(finalizedFeatures).empty());
        Assertions.assertFalse((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, finalizedFeatures));
    }

    @Test
    public void testDefaultFinalizedFeatures() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)new SupportedVersionRange(3, 7))}))).asJava());
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map expectedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new FinalizedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new FinalizedVersionRange(1, 3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)new FinalizedVersionRange(3, 7))}));
        Assertions.assertEquals((Object)Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedFeatures).asJava()), (Object)brokerFeatures.defaultFinalizedFeatures());
    }
}

