/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmb!B\u0015+\u0003\u0003y\u0003\"\u0002\u001c\u0001\t\u00039\u0004b\u0002\u001e\u0001\u0001\u0004%\ta\u000f\u0005\b\u0015\u0002\u0001\r\u0011\"\u0001L\u0011\u0019\u0011\u0006\u0001)Q\u0005y!91\u000b\u0001a\u0001\n\u0003!\u0006b\u00020\u0001\u0001\u0004%\ta\u0018\u0005\u0007C\u0002\u0001\u000b\u0015B+\t\u000f\t\u0004\u0001\u0019!C\u0001G\"9q\u000e\u0001a\u0001\n\u0003\u0001\bB\u0002:\u0001A\u0003&A\rC\u0004t\u0001\u0001\u0007I\u0011\u0001;\t\u000fm\u0004\u0001\u0019!C\u0001y\"1a\u0010\u0001Q!\nUDQa \u0001\u0007\u0002mBq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0006\u0001!\t!a\u0001\t\r\u0005\u001d\u0001\u0001\"\u0001<\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002$\u0001!\t\"!\n\t\u000f\u0005\u0015\u0003\u0001\"\u0005\u0002H!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBA6\u0001\u0011E\u0011Q\u000e\u0005\b\u0003{\u0002A\u0011CA7\u0011\u001d\ty\b\u0001C\t\u0003\u0003Cq!a%\u0001\t#\t)\nC\u0004\u0002\u0018\u0002!\t%a\u0001\t\u000f\u0005=\u0006\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006\"CAm\u0001E\u0005I\u0011AAn\u0011%\t\t\u0010AI\u0001\n\u0003\tY\u000eC\u0005\u0002t\u0002\t\n\u0011\"\u0001\u0002v\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005e\bb\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003\u0007AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!Q\u0007\u0001\u0005\u0002\t]\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u000b\u0005-b\u0013aC5oi\u0016<'/\u0019;j_:T\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022i5\t!G\u0003\u00024Y\u0005\u0011!p[\u0005\u0003kI\u0012ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001+\u0003=Ign\u001d;b]\u000e,7i\u001c8gS\u001e\u001cX#\u0001\u001f\u0011\u0007u\u0012E)D\u0001?\u0015\ty\u0004)\u0001\u0006d_2dWm\u0019;j_:T\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007z\u00121aU3r!\t)\u0005*D\u0001G\u0015\t9E&\u0001\u0004tKJ4XM]\u0005\u0003\u0013\u001a\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006\u0019\u0012N\\:uC:\u001cWmQ8oM&<7o\u0018\u0013fcR\u0011A\n\u0015\t\u0003\u001b:k\u0011\u0001Q\u0005\u0003\u001f\u0002\u0013A!\u00168ji\"9\u0011kAA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005\u0001\u0012N\\:uC:\u001cWmQ8oM&<7\u000fI\u0001\bg\u0016\u0014h/\u001a:t+\u0005)\u0006c\u0001,Z76\tqK\u0003\u0002Y}\u00059Q.\u001e;bE2,\u0017B\u0001.X\u0005\u0019\u0011UO\u001a4feB\u0011Q\tX\u0005\u0003;\u001a\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\ta\u0005\rC\u0004R\r\u0005\u0005\t\u0019A+\u0002\u0011M,'O^3sg\u0002\n!B\u0019:pW\u0016\u0014H*[:u+\u0005!\u0007CA3m\u001d\t1'\u000e\u0005\u0002h\u00016\t\u0001N\u0003\u0002j]\u00051AH]8pizJ!a\u001b!\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003W\u0002\u000baB\u0019:pW\u0016\u0014H*[:u?\u0012*\u0017\u000f\u0006\u0002Mc\"9\u0011+CA\u0001\u0002\u0004!\u0017a\u00032s_.,'\u000fT5ti\u0002\nQ!\u00197jm\u0016,\u0012!\u001e\t\u0004\u001bZD\u0018BA<A\u0005\u0015\t%O]1z!\ti\u00150\u0003\u0002{\u0001\n9!i\\8mK\u0006t\u0017!C1mSZ,w\fJ3r)\taU\u0010C\u0004R\u0019\u0005\u0005\t\u0019A;\u0002\r\u0005d\u0017N^3!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001c\u0018aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f\u001e\u000b\u0002\u0019\u0006\u00113m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=BMR,'oU3sm\u0016\u00148o\u0015;beR\fqaY8oM&<7/A\u0006tKJ4XM\u001d$pe&#G\u0003BA\u0007\u0003'\u0001B!TA\b7&\u0019\u0011\u0011\u0003!\u0003\r=\u0003H/[8o\u0011\u001d\t)B\u0005a\u0001\u0003/\t!!\u001b3\u0011\u00075\u000bI\"C\u0002\u0002\u001c\u0001\u00131!\u00138u\u0003%\u0011w.\u001e8e!>\u0014H\u000f\u0006\u0003\u0002\u0018\u0005\u0005\u0002\"B$\u0014\u0001\u0004Y\u0016\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\t\t9\u0003\u0005\u0003\u0002*\u0005\u0005SBAA\u0016\u0015\u0011\ti#a\f\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003c\t\u0019$\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0011\t)$a\u000e\u0002\r\r|W.\\8o\u0015\ri\u0013\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u007f\t1a\u001c:h\u0013\u0011\t\u0019%a\u000b\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001\u00047jgR,g.\u001a:OC6,WCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#\u0002BA(\u0003g\tqA\\3uo>\u00148.\u0003\u0003\u0002T\u00055#\u0001\u0004'jgR,g.\u001a:OC6,\u0017A\u0004;skN$8\u000b^8sK\u001aKG.Z\u000b\u0003\u00033\u0002R!TA\b\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0002j_*\u0011\u0011QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005}#\u0001\u0002$jY\u0016\fAc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001cXCAA8!\u0015i\u0015qBA9!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$\u0002BA<\u0003G\nA!\u001e;jY&!\u00111PA;\u0005)\u0001&o\u001c9feRLWm]\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002\u0015\t\u0014xn[3s)&lW\r\u0006\u0003\u0002\u0004\u0006=\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\t\u0005%\u00151G\u0001\u0006kRLGn]\u0005\u0005\u0003\u001b\u000b9I\u0001\u0003US6,\u0007bBAI3\u0001\u0007\u0011qC\u0001\tEJ|7.\u001a:JI\u0006\u0001RM\\1cY\u00164uN]<be\u0012LgnZ\u000b\u0002q\u0006)1/\u001a;Va\"\u001a1$a'\u0011\t\u0005u\u00151V\u0007\u0003\u0003?SA!!)\u0002$\u0006\u0019\u0011\r]5\u000b\t\u0005\u0015\u0016qU\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tI+!\u0010\u0002\u000b),h.\u001b;\n\t\u00055\u0016q\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007q\t\u0019\f\u0005\u0003\u0002\u001e\u0006U\u0016\u0002BA\\\u0003?\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u000b\u0003{\u000bI-!4\u0002R\u0006U\u0007\u0003CA`\u0003\u000b\f9\"a\u0006\u000e\u0005\u0005\u0005'bAAb}\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u000f\f\tMA\u0002NCBDa!a3\u001e\u0001\u0004!\u0017!\u0002;pa&\u001c\u0007\"CAh;A\u0005\t\u0019AA\f\u00035qW/\u001c)beRLG/[8og\"I\u00111[\u000f\u0011\u0002\u0003\u0007\u0011qC\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\"CAl;A\u0005\t\u0019AA9\u0003-!x\u000e]5d\u0007>tg-[4\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001c\u0016\u0005\u0003/\tyn\u000b\u0002\u0002bB!\u00111]Aw\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018!C;oG\",7m[3e\u0015\r\tY\u000fQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAx\u0003K\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIM\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002x*\"\u0011\u0011OAp)\u0019\ti,a?\u0002~\"1\u00111Z\u0011A\u0002\u0011Dq!a@\"\u0001\u0004\u0011\t!\u0001\u000eqCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fE\u0004>\u0005\u0007\t9B!\u0002\n\u0007\u0005\u001dg\b\u0005\u0003>\u0005\u0006]\u0011\u0001E6jY2\u0014\u0016M\u001c3p[\n\u0013xn[3s)\t\t9\"\u0001\u0006lS2d'I]8lKJ$2\u0001\u0014B\b\u0011\u001d\u0011\tb\ta\u0001\u0003/\tQ!\u001b8eKb\f!C]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sg\u0006qs/Y5u\r>\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYR{\u0017\t\u001d9fCJ|e.\u00117m\u0005J|7.\u001a:t)\u0015a%\u0011\u0004B\u000f\u0011\u0019\u0011Y\"\na\u0001I\u0006y1\r\\5f]R\u0004&/\u001b8dSB\fG\u000e\u0003\u0004\u0003 \u0015\u0002\r\u0001Z\u0001\u000e[\u0016\u001c\u0007.\u00198jg6t\u0015-\\3\u0002\u001b\u001d,GoQ8oiJ|G\u000e\\3s)\u0005Y\u0016aC4fiR{\u0007/[2JIN$\"A!\u000b\u0011\r\u0015\u0014Y\u0003\u001aB\u0017\u0013\r\t9M\u001c\t\u0005\u0005_\u0011\t$\u0004\u0002\u00024%!!1GA\u001a\u0005\u0011)V/\u001b3\u0002\u001b\u001d,G\u000fV8qS\u000et\u0015-\\3t)\t\u0011I\u0004\u0005\u0004f\u0005W\u0011i\u0003\u001a")
public abstract class KafkaServerTestHarness
extends ZooKeeperTestHarness {
    private Seq<KafkaConfig> instanceConfigs = null;
    private Buffer<KafkaServer> servers = new ArrayBuffer();
    private String brokerList = null;
    private boolean[] alive = null;

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerList() {
        return this.brokerList;
    }

    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart() {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    public boolean enableForwarding() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart();
        this.configs().foreach((Function1 & Serializable)config -> (Buffer)this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer((KafkaConfig)config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, this.enableForwarding())));
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.alive_$eq(new boolean[this.servers().length()]);
        Arrays.fill(this.alive(), true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.servers() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        }
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaServer>)this.servers(), topicConfig);
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaServer>)this.servers());
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this.servers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaServer)this.servers().apply(index)).shutdown();
            ((KafkaServer)this.servers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void restartDeadBrokers() {
        this.servers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ((KafkaServer)this.servers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this.servers().foreach((Function1 & Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        return this.getController().kafkaController().controllerContext().topicIds().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        return this.getController().kafkaController().controllerContext().topicNames().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }
}

