/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.OffsetSync;

class OffsetSyncStore
implements AutoCloseable {
    private KafkaConsumer<byte[], byte[]> consumer;
    private Map<TopicPartition, OffsetSync> offsetSyncs = new HashMap<TopicPartition, OffsetSync>();
    private TopicPartition offsetSyncTopicPartition;

    OffsetSyncStore(MirrorConnectorConfig config) {
        this.consumer = new KafkaConsumer(config.sourceConsumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.offsetSyncTopicPartition = new TopicPartition(config.offsetSyncsTopic(), 0);
        this.consumer.assign(Collections.singleton(this.offsetSyncTopicPartition));
    }

    OffsetSyncStore(KafkaConsumer<byte[], byte[]> consumer, TopicPartition offsetSyncTopicPartition) {
        this.consumer = consumer;
        this.offsetSyncTopicPartition = offsetSyncTopicPartition;
    }

    long translateDownstream(TopicPartition sourceTopicPartition, long upstreamOffset) {
        OffsetSync offsetSync = this.latestOffsetSync(sourceTopicPartition);
        if (offsetSync.upstreamOffset() > upstreamOffset) {
            return -1L;
        }
        long upstreamStep = upstreamOffset - offsetSync.upstreamOffset();
        return offsetSync.downstreamOffset() + upstreamStep;
    }

    synchronized void update(Duration pollTimeout) {
        try {
            this.consumer.poll(pollTimeout).forEach(this::handleRecord);
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        this.consumer.wakeup();
        Utils.closeQuietly(this.consumer, (String)"offset sync store consumer");
    }

    protected void handleRecord(ConsumerRecord<byte[], byte[]> record) {
        OffsetSync offsetSync = OffsetSync.deserializeRecord(record);
        TopicPartition sourceTopicPartition = offsetSync.topicPartition();
        this.offsetSyncs.put(sourceTopicPartition, offsetSync);
    }

    private OffsetSync latestOffsetSync(TopicPartition topicPartition) {
        return this.offsetSyncs.computeIfAbsent(topicPartition, x -> new OffsetSync(topicPartition, -1L, -1L));
    }
}

