/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.connect.mirror.Checkpoint;
import org.apache.kafka.connect.mirror.MirrorClientConfig;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MirrorClient.class);
    private AdminClient adminClient;
    private ReplicationPolicy replicationPolicy;
    private Map<String, Object> consumerConfig;

    public MirrorClient(Map<String, Object> props) {
        this(new MirrorClientConfig(props));
    }

    public MirrorClient(MirrorClientConfig config) {
        this.adminClient = AdminClient.create(config.adminConfig());
        this.consumerConfig = config.consumerConfig();
        this.replicationPolicy = config.replicationPolicy();
    }

    MirrorClient(AdminClient adminClient, ReplicationPolicy replicationPolicy, Map<String, Object> consumerConfig) {
        this.adminClient = adminClient;
        this.replicationPolicy = replicationPolicy;
        this.consumerConfig = consumerConfig;
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    public ReplicationPolicy replicationPolicy() {
        return this.replicationPolicy;
    }

    public int replicationHops(String upstreamClusterAlias) throws InterruptedException {
        return this.heartbeatTopics().stream().map(x -> this.countHopsForTopic((String)x, upstreamClusterAlias)).filter(x -> x != -1).mapToInt(x -> x).min().orElse(-1);
    }

    public Set<String> heartbeatTopics() throws InterruptedException {
        return this.listTopics().stream().filter(this::isHeartbeatTopic).collect(Collectors.toSet());
    }

    public Set<String> checkpointTopics() throws InterruptedException {
        return this.listTopics().stream().filter(this::isCheckpointTopic).collect(Collectors.toSet());
    }

    public Set<String> upstreamClusters() throws InterruptedException {
        return this.listTopics().stream().filter(this::isHeartbeatTopic).flatMap(x -> this.allSources((String)x).stream()).distinct().collect(Collectors.toSet());
    }

    public Set<String> remoteTopics() throws InterruptedException {
        return this.listTopics().stream().filter(this::isRemoteTopic).collect(Collectors.toSet());
    }

    public Set<String> remoteTopics(String source) throws InterruptedException {
        return this.listTopics().stream().filter(this::isRemoteTopic).filter(x -> source.equals(this.replicationPolicy.topicSource((String)x))).distinct().collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TopicPartition, OffsetAndMetadata> remoteConsumerOffsets(String consumerGroupId, String remoteClusterAlias, Duration timeout) {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        try (KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            String checkpointTopic = remoteClusterAlias + ".checkpoints.internal";
            List<TopicPartition> checkpointAssignment = Collections.singletonList(new TopicPartition(checkpointTopic, 0));
            consumer.assign(checkpointAssignment);
            consumer.seekToBeginning(checkpointAssignment);
            while (System.currentTimeMillis() < deadline && !MirrorClient.endOfStream(consumer, checkpointAssignment)) {
                ConsumerRecords records = consumer.poll(timeout);
                for (ConsumerRecord record : records) {
                    try {
                        Checkpoint checkpoint = Checkpoint.deserializeRecord((ConsumerRecord<byte[], byte[]>)record);
                        if (!checkpoint.consumerGroupId().equals(consumerGroupId)) continue;
                        offsets.put(checkpoint.topicPartition(), checkpoint.offsetAndMetadata());
                    }
                    catch (SchemaException e) {
                        log.info("Could not deserialize record. Skipping.", (Throwable)e);
                    }
                }
            }
            log.info("Consumed {} checkpoint records for {} from {}.", new Object[]{offsets.size(), consumerGroupId, checkpointTopic});
        }
        return offsets;
    }

    Set<String> listTopics() throws InterruptedException {
        try {
            return (Set)this.adminClient.listTopics().names().get();
        }
        catch (ExecutionException e) {
            throw new KafkaException(e.getCause());
        }
    }

    int countHopsForTopic(String topic, String sourceClusterAlias) {
        int hops = 0;
        while (true) {
            ++hops;
            String source = this.replicationPolicy.topicSource(topic);
            if (source == null) {
                return -1;
            }
            if (source.equals(sourceClusterAlias)) {
                return hops;
            }
            topic = this.replicationPolicy.upstreamTopic(topic);
        }
    }

    boolean isHeartbeatTopic(String topic) {
        return "heartbeats".equals(this.replicationPolicy.originalTopic(topic));
    }

    boolean isCheckpointTopic(String topic) {
        return topic.endsWith(".checkpoints.internal");
    }

    boolean isRemoteTopic(String topic) {
        return !this.replicationPolicy.isInternalTopic(topic) && this.replicationPolicy.topicSource(topic) != null;
    }

    Set<String> allSources(String topic) {
        HashSet<String> sources = new HashSet<String>();
        String source = this.replicationPolicy.topicSource(topic);
        while (source != null) {
            sources.add(source);
            topic = this.replicationPolicy.upstreamTopic(topic);
            source = this.replicationPolicy.topicSource(topic);
        }
        return sources;
    }

    private static boolean endOfStream(Consumer<?, ?> consumer, Collection<TopicPartition> assignments) {
        Map endOffsets = consumer.endOffsets(assignments);
        for (TopicPartition topicPartition : assignments) {
            if (consumer.position(topicPartition) >= (Long)endOffsets.get(topicPartition)) continue;
            return false;
        }
        return true;
    }
}

