/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.VersionRange;

public class BrokerRegistration {
    private final int id;
    private final long epoch;
    private final Uuid incarnationId;
    private final Map<String, Endpoint> listeners;
    private final Map<String, VersionRange> supportedFeatures;
    private final Optional<String> rack;
    private final boolean fenced;

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, List<Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced) {
        this.id = id;
        this.epoch = epoch;
        this.incarnationId = incarnationId;
        HashMap listenersMap = new HashMap();
        for (Endpoint endpoint : listeners) {
            listenersMap.put(endpoint.listenerName().get(), endpoint);
        }
        this.listeners = Collections.unmodifiableMap(listenersMap);
        Objects.requireNonNull(supportedFeatures);
        this.supportedFeatures = new HashMap<String, VersionRange>(supportedFeatures);
        Objects.requireNonNull(rack);
        this.rack = rack;
        this.fenced = fenced;
    }

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced) {
        this.id = id;
        this.epoch = epoch;
        this.incarnationId = incarnationId;
        this.listeners = new HashMap<String, Endpoint>(listeners);
        this.supportedFeatures = new HashMap<String, VersionRange>(supportedFeatures);
        this.rack = rack;
        this.fenced = fenced;
    }

    public int id() {
        return this.id;
    }

    public long epoch() {
        return this.epoch;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrokerRegistration)) {
            return false;
        }
        BrokerRegistration other = (BrokerRegistration)o;
        return other.id == this.id && other.epoch == this.epoch && other.incarnationId.equals((Object)this.incarnationId) && other.listeners.equals(this.listeners) && other.supportedFeatures.equals(this.supportedFeatures) && other.rack.equals(this.rack) && other.fenced == this.fenced;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("BrokerRegistration(id=").append(this.id);
        bld.append(", epoch=").append(this.epoch);
        bld.append(", incarnationId=").append(this.incarnationId);
        bld.append(", listeners=[").append(this.listeners.keySet().stream().sorted().map(n -> this.listeners.get(n).toString()).collect(Collectors.joining(", ")));
        bld.append("], supportedFeatures={").append(this.supportedFeatures.entrySet().stream().sorted().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ")));
        bld.append("}");
        bld.append(", rack=").append(this.rack);
        bld.append(", fenced=").append(this.fenced);
        bld.append(")");
        return bld.toString();
    }

    public BrokerRegistration cloneWithFencing(boolean fencing) {
        return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, fencing);
    }
}

