/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.util;

import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"itemIdOf", "Lde/justsoftware/wikiservice/model/ItemId;", "id", "Ljava/util/UUID;", "idType", "Lde/justsoftware/wikiservice/model/IdType;", "idString", "", "parentIdOf", "Lde/justsoftware/wikiservice/model/ParentId;", "parseLongId", "", "longId", "(Ljava/lang/String;)Ljava/lang/Long;", "wiki-service"})
public final class IdUtilsKt {
    @NotNull
    public static final ParentId parentIdOf(@NotNull UUID id, @NotNull IdType idType) {
        ParentId parentId;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)idType, (String)"idType");
        IdType idType2 = idType;
        int n = WhenMappings.$EnumSwitchMapping$0[idType2.ordinal()];
        switch (n) {
            case 1: {
                parentId = (ParentId)new ChapterId(id);
                break;
            }
            case 2: {
                parentId = (ParentId)new WikiId(id);
                break;
            }
            default: {
                throw new IllegalArgumentException(idType + " is not a parent type");
            }
        }
        return parentId;
    }

    @NotNull
    public static final ParentId parentIdOf(@NotNull String idString) {
        ParentId parentId;
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (StringsKt.startsWith$default((String)idString, (String)IdType.WIKI_WIKI.name(), (boolean)false, (int)2, null)) {
            parentId = (ParentId)new WikiId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)IdType.WIKI_CHAPTER.name(), (boolean)false, (int)2, null)) {
            parentId = (ParentId)new ChapterId(idString);
        } else {
            throw new IllegalArgumentException("Unknown parent type " + idString);
        }
        return parentId;
    }

    @NotNull
    public static final ItemId itemIdOf(@NotNull UUID id, @NotNull IdType idType) {
        ItemId itemId;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)idType, (String)"idType");
        IdType idType2 = idType;
        int n = WhenMappings.$EnumSwitchMapping$0[idType2.ordinal()];
        switch (n) {
            case 2: {
                itemId = (ItemId)new WikiId(id);
                break;
            }
            case 1: {
                itemId = (ItemId)new ChapterId(id);
                break;
            }
            case 3: {
                itemId = (ItemId)new ArticleId(id);
                break;
            }
            default: {
                throw new IllegalArgumentException(idType + " is not an item type");
            }
        }
        return itemId;
    }

    @NotNull
    public static final ItemId itemIdOf(@NotNull String idString) {
        ItemId itemId;
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (StringsKt.startsWith$default((String)idString, (String)IdType.WIKI_WIKI.name(), (boolean)false, (int)2, null)) {
            itemId = (ItemId)new WikiId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)IdType.WIKI_CHAPTER.name(), (boolean)false, (int)2, null)) {
            itemId = (ItemId)new ChapterId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)IdType.WIKI_ARTICLE.name(), (boolean)false, (int)2, null)) {
            itemId = (ItemId)new ArticleId(idString);
        } else {
            throw new IllegalArgumentException("Unknown item type " + idString);
        }
        return itemId;
    }

    @Nullable
    public static final Long parseLongId(@NotNull String longId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)longId, (String)"longId");
        Object object2 = new String[]{","};
        List idParts = StringsKt.split$default((CharSequence)longId, (String[])object2, (boolean)false, (int)0, (int)6, null);
        if (idParts.size() != 2) {
            object = null;
        } else {
            try {
                object2 = (String)idParts.get(1);
                boolean bl = false;
                object2 = Long.parseLong((String)object2);
            }
            catch (NumberFormatException ex) {
                object2 = null;
            }
            object = object2;
        }
        return object;
    }
}

