/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.RepositoryUtilKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J*\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H'J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0017J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H'J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0017J\u001e\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0017J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0010H\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010H&J(\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0017J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007H&J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007H&J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u001f\u001a\u00020 H'J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H'J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0017J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H'J2\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0017J\"\u0010&\u001a\u00020\u000e2\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0001\u0010\u0014\u001a\u00020\u0010H'J\u001c\u0010'\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u00072\b\b\u0001\u0010\u0014\u001a\u00020\u0010H'J&\u0010(\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017J,\u0010-\u001a\u00020\u000e2\u000e\b\u0001\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0001\u0010)\u001a\u00020*2\b\b\u0001\u0010+\u001a\u00020,H'J0\u0010.\u001a\u00020\u000e2\b\b\u0001\u0010/\u001a\u00020\"2\b\b\u0001\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u0002032\b\b\u0001\u00104\u001a\u00020\u0003H'\u00a8\u00065"}, d2={"Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "Lde/justsoftware/wikiservice/model/ChapterId;", "countByWikiIdIn", "", "Lkotlin/Pair;", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "countByWikiIds", "", "", "deleteAllByDeletionIdIn", "", "deletionIds", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleteAllByDeletionIds", "deleteByIds", "ids", "deletionId", "deleteByWikiId", "wikiId", "findAllByDeletionId", "findAllByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "findAllByWikiId", "findAllByWikiIdAndDeletionIdIsNull", "findByDeletionIdIsNullAndIdIn", "chapterIds", "sort", "Lorg/springframework/data/domain/Sort;", "findByDeletionIdIsNullAndParentIdInOrderByTitle", "Ljava/util/UUID;", "findByIds", "findByParentIdIn", "findByParentIds", "markChaptersByChapterIdsAsDeleted", "markChaptersByWikiIdAsDeleted", "setUpdatedStatus", "updatedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "updatedAt", "Ljava/time/Instant;", "setUpdatedStatusIn", "updateParentIdAndPosition", "parentId", "parentType", "Lde/justsoftware/wikiservice/model/IdType;", "relativePosition", "", "id", "wiki-service"})
public interface ChapterRepository
extends DeletionFlagRepository<Chapter, ChapterId> {
    @NotNull
    public Set<Chapter> findAllByWikiId(@NotNull WikiId var1);

    @NotNull
    public Set<Chapter> findAllByWikiIdAndDeletionIdIsNull(@NotNull WikiId var1);

    @Deprecated(message="Use {@link #findByIds(ImmutableSet)} instead.")
    @NotNull
    public List<Chapter> findByDeletionIdIsNullAndIdIn(@NotNull List<? extends ChapterId> var1, @NotNull Sort var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public List<Chapter> findByIds(@NotNull Set<? extends ChapterId> chapterIds, @NotNull Sort sort) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)chapterIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List ids = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByDeletionIdIsNullAndIdIn(ids, sort);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findByIds$default(ChapterRepository chapterRepository, Set set, Sort sort, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByIds");
        }
        if ((n & 2) != 0) {
            sort = RepositoryUtilKt.getChapterDefaultSort();
        }
        return chapterRepository.findByIds(set, sort);
    }

    @Deprecated(message="Use {@link #findByParentIds(ImmutableSet)} instead.")
    @NotNull
    public List<Chapter> findByDeletionIdIsNullAndParentIdInOrderByTitle(@NotNull List<UUID> var1);

    @Deprecated(message="Use {@link #findAllByParentIds(ImmutableSet)} instead.")
    @NotNull
    public List<Chapter> findByParentIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<ParentId, List<Chapter>> findByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull Sort sort) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Chapter it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$map$iv = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getId();
            collection.add(uUID);
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findByDeletionIdIsNullAndParentIdInOrderByTitle(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Chapter)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map findByParentIds$default(ChapterRepository chapterRepository, Set set, Sort sort, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByParentIds");
        }
        if ((n & 2) != 0) {
            sort = RepositoryUtilKt.getChapterDefaultSort();
        }
        return chapterRepository.findByParentIds(set, sort);
    }

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<ParentId, List<Chapter>> findAllByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Chapter it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$map$iv = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getId();
            collection.add(uUID);
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findByParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Chapter)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @JvmDefault
    @Transactional
    @NotNull
    default public Set<Chapter> deleteByWikiId(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        this.markChaptersByWikiIdAsDeleted(wikiId, deletionId);
        Unit unit = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Unit it = unit;
        boolean bl3 = false;
        return this.findAllByDeletionId(deletionId);
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteByWikiId(WikiId, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE Chapter c\n            SET c.deletionId = :deletionId\n            WHERE c.deletionId = null AND c.wikiId = :wikiId\n        ")
    public void markChaptersByWikiIdAsDeleted(@Param(value="wikiId") @NotNull WikiId var1, @Param(value="deletionId") @NotNull DeletionId var2);

    @Deprecated(message="Do not use this function directly. Use {@link #deleteByIds(Set)} instead.")
    @Modifying
    @Query(value="\n       UPDATE Chapter c\n       SET c.deletionId = :deletionId\n       WHERE c.deletionId = null AND c.id IN :ids\n    ")
    public void markChaptersByChapterIdsAsDeleted(@Param(value="ids") @NotNull List<? extends ChapterId> var1, @Param(value="deletionId") @NotNull DeletionId var2);

    @Transactional
    @JvmDefault
    default public void deleteByIds(@NotNull Set<? extends ChapterId> ids, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)ids, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.markChaptersByChapterIdsAsDeleted(it, deletionId);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #countByWikiIds(Set)} instead.")
    @Query(value="\n       SELECT new kotlin.Pair(c.wikiId, count(c))\n       FROM Chapter c\n       WHERE c.wikiId in :wikiIds\n       AND c.deletionId = null\n       GROUP BY wikiId\n    ")
    @NotNull
    public List<Pair<WikiId, Long>> countByWikiIdIn(@Param(value="wikiIds") @NotNull List<? extends WikiId> var1);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<WikiId, Long> countByWikiIds(@NotNull Set<? extends WikiId> wikiIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)wikiIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.countByWikiIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Set<Chapter> findAllByDeletionId(@NotNull DeletionId var1);

    @Transactional
    @JvmDefault
    default public void deleteAllByDeletionIds(@NotNull Set<? extends DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<? extends DeletionId> var1);

    /*
     * WARNING - void declaration
     */
    @Transactional
    @JvmDefault
    default public void setUpdatedStatus(@NotNull Set<? extends ChapterId> chapterIds, @NotNull ProfileId updatedBy, @NotNull Instant updatedAt) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Iterable iterable = CollectionsKt.chunked((Iterable)chapterIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.setUpdatedStatusIn(it, updatedBy, updatedAt);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #setUpdatedStatus(Set, ProfileId, Instant)} instead.")
    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE Chapter c\n            SET c.updatedAt = :updatedAt,\n                c.modifiedBy = :updatedBy\n            WHERE c.id IN :chapterIds\n        ")
    public void setUpdatedStatusIn(@Param(value="chapterIds") @NotNull List<? extends ChapterId> var1, @Param(value="updatedBy") @NotNull ProfileId var2, @Param(value="updatedAt") @NotNull Instant var3);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE Chapter c\n            SET c.parentId = :parentId,\n                c.parentType = :parentType,\n                c.relativePosition = :relativePosition\n            WHERE c.id = :id\n        ")
    public void updateParentIdAndPosition(@Param(value="parentId") @NotNull UUID var1, @Param(value="parentType") @NotNull IdType var2, @Param(value="relativePosition") int var3, @Param(value="id") @NotNull ChapterId var4);
}

