/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.kafka.AbstractKafkaConsumer;
import de.justsoftware.wikiservice.kafka.KafkaConsumerContext;
import de.justsoftware.wikiservice.kafka.ProfileKafkaConsumer;
import de.justsoftware.wikiservice.persistence.model.Profile;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00192\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B+\b\u0007\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ)\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/kafka/ProfileKafkaConsumer;", "Lde/justsoftware/wikiservice/kafka/AbstractKafkaConsumer;", "", "Lde/justsoftware/wikiservice/persistence/model/Profile;", "bootstrapServers", "maxChunkSize", "", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "(Ljava/lang/String;ILde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/business/PermissionService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "logger", "kotlin.jvm.PlatformType", "process", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "context", "Lde/justsoftware/wikiservice/kafka/KafkaConsumerContext;", "process$wiki_service", "Companion", "wiki-service"})
public class ProfileKafkaConsumer
extends AbstractKafkaConsumer<String, Profile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionService permissionService;
    private final Logger logger;
    @NotNull
    public static final String topic = "just.persons";

    @Autowired
    public ProfileKafkaConsumer(@Value(value="${kafka.bootstrapServers:localhost:9092}") @NotNull String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize, @NotNull ProfileService profileService, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        super(Companion.createConsumer(bootstrapServers, maxChunkSize), SetsKt.setOf((Object)topic));
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
        this.profileService = profileService;
        this.permissionService = permissionService;
        this.logger = LoggerFactory.getLogger(ProfileKafkaConsumer.class);
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        return logger;
    }

    public void process$wiki_service(@NotNull ConsumerRecords<String, Profile> records, @NotNull KafkaConsumerContext context) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                Profile profile = (Profile)record.value();
                Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"profile");
                this.profileService.save(profile);
                if (!profile.getDeleted()) continue;
                this.permissionService.deletePermissionsForGrantee(profile.getId().toGranteeId());
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to save or update profile with id = " + ((Profile)record.value()).getId() + ". Skip this record.", (Throwable)e);
            }
        }
    }
}

