/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.ChapterApplicationService;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationCreateChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryChapterArgs;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0014H\u0017J\u001a\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0014H\u0017J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;", "", "chapterApplicationService", "Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "(Lde/justsoftware/wikiservice/application/ChapterApplicationService;)V", "allByChapter", "Lgraphql/schema/DataFetcher;", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "getAllByChapter", "()Lgraphql/schema/DataFetcher;", "allByWiki", "getAllByWiki", "byId", "getById", "countByWiki", "", "getCountByWiki", "chapterCountForWholeWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/WikiId;", "childChapterDataLoaderFactory", "Lde/justsoftware/wikiservice/model/ParentId;", "create", "delete", "update", "wiki-service"})
public class ChapterFetcher {
    @NotNull
    private final ChapterApplicationService chapterApplicationService;
    @NotNull
    private final DataFetcher<ChapterDto> byId;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ChapterDto>>> allByChapter;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ChapterDto>>> allByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<Integer>> countByWiki;

    @Autowired
    public ChapterFetcher(@NotNull ChapterApplicationService chapterApplicationService) {
        Intrinsics.checkNotNullParameter((Object)chapterApplicationService, (String)"chapterApplicationService");
        this.chapterApplicationService = chapterApplicationService;
        this.byId = arg_0 -> ChapterFetcher.byId$lambda-0(this, arg_0);
        this.allByChapter = ChapterFetcher::allByChapter$lambda-1;
        this.allByWiki = ChapterFetcher::allByWiki$lambda-2;
        this.countByWiki = ChapterFetcher::countByWiki$lambda-4;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ParentId, List<ChapterDto>> childChapterDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.CHILD_CHAPTERS_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Integer> chapterCountForWholeWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.WIKI_CHAPTER_COUNT_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public DataFetcher<ChapterDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ChapterDto>>> getAllByChapter() {
        return this.allByChapter;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ChapterDto>>> getAllByWiki() {
        return this.allByWiki;
    }

    @NotNull
    public DataFetcher<ChapterDto> create() {
        return arg_0 -> ChapterFetcher.create$lambda-3(this, arg_0);
    }

    @NotNull
    public DataFetcher<CompletableFuture<Integer>> getCountByWiki() {
        return this.countByWiki;
    }

    @NotNull
    public DataFetcher<ChapterDto> update() {
        return arg_0 -> ChapterFetcher.update$lambda-5(this, arg_0);
    }

    @NotNull
    public DataFetcher<ChapterDto> delete() {
        return arg_0 -> ChapterFetcher.delete$lambda-6(this, arg_0);
    }

    private static final ChapterDto byId$lambda-0(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        QueryChapterArgs args = new QueryChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.read(args.getId(), context.getAuthContext());
    }

    private static final CompletableFuture allByChapter$lambda-1(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_CHAPTERS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ChapterDto chapter = (ChapterDto)object2;
        return dataLoader.load((Object)chapter.getId());
    }

    private static final CompletableFuture allByWiki$lambda-2(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_CHAPTERS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final ChapterDto create$lambda-3(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationCreateChapterArgs args = new MutationCreateChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.create(args.getChapter(), context.getAuthContext());
    }

    private static final CompletableFuture countByWiki$lambda-4(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.WIKI_CHAPTER_COUNT_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final ChapterDto update$lambda-5(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationUpdateChapterArgs args = new MutationUpdateChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.update(args.getId(), args.getChapter(), context.getAuthContext());
    }

    private static final ChapterDto delete$lambda-6(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationDeleteChapterArgs args = new MutationDeleteChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.delete(args.getId(), context.getAuthContext());
    }

    public static final /* synthetic */ ChapterApplicationService access$getChapterApplicationService$p(ChapterFetcher $this) {
        return $this.chapterApplicationService;
    }
}

