/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import de.justsoftware.wikiservice.business.model.GroupGranteeDto;
import de.justsoftware.wikiservice.business.model.ProfileGranteeDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsArticleDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsChapterDto;
import de.justsoftware.wikiservice.graphql.GraphQLScalar;
import de.justsoftware.wikiservice.graphql.SimpleComplexityCalculator;
import de.justsoftware.wikiservice.graphql.error.CustomGraphQLErrorHandler;
import de.justsoftware.wikiservice.graphql.fetchers.AncestorFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ArticleFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ChapterFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.GlobalUserInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.PermissionFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ProfileInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.SubscriptionFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.TableOfContentsFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.UserInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.WikiFetcher;
import de.justsoftware.wikiservice.graphql.generated.PermissionType;
import graphql.GraphQL;
import graphql.TypeResolutionEnvironment;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.DataFetcherResult;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.NaturalEnumValuesProvider;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001Bs\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0001\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0001\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001bJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020 H\u0002J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000208H\u0017J\b\u00109\u001a\u00020:H\u0017J\"\u0010;\u001a\u0002062\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=\u00a2\u0006\u0002\b@H\u0082\bJ\u0010\u0010A\u001a\u0002032\u0006\u00109\u001a\u00020:H\u0017J.\u0010B\u001a\u00020>*\u00020>2\u0006\u0010C\u001a\u00020 2\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020?0=\u00a2\u0006\u0002\b@H\u0082\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\u001c\u001a\\\u0012X\u0012V\u0012$\u0012\"\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001 !*\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001f0\u001f !**\u0012$\u0012\"\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001 !*\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001f0\u001f\u0018\u00010\u001e0\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R$\u0010(\u001a\u00020)8\u0016@\u0016X\u0097.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lde/justsoftware/wikiservice/graphql/GraphQLProvider;", "", "wikiFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/WikiFetcher;", "tableOfContentsFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/TableOfContentsFetcher;", "articleFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;", "chapterFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;", "ancestorFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/AncestorFetcher;", "permissionFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/PermissionFetcher;", "subscriptionFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;", "userInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/UserInfoFetcher;", "profileInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ProfileInfoFetcher;", "globalUserInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/GlobalUserInfoFetcher;", "simpleComplexityCalculator", "Lde/justsoftware/wikiservice/graphql/SimpleComplexityCalculator;", "maxQueryDepth", "", "maxQueryComplexity", "(Lde/justsoftware/wikiservice/graphql/fetchers/WikiFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/TableOfContentsFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/AncestorFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/PermissionFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/UserInfoFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ProfileInfoFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/GlobalUserInfoFetcher;Lde/justsoftware/wikiservice/graphql/SimpleComplexityCalculator;II)V", "genericFetcher", "Lgraphql/schema/DataFetcher;", "Lgraphql/execution/DataFetcherResult;", "", "", "kotlin.jvm.PlatformType", "getGenericFetcher", "()Lgraphql/schema/DataFetcher;", "granteeResolver", "Lgraphql/schema/TypeResolver;", "getGranteeResolver", "()Lgraphql/schema/TypeResolver;", "graphQL", "Lgraphql/GraphQL;", "getGraphQL$annotations", "()V", "getGraphQL", "()Lgraphql/GraphQL;", "setGraphQL", "(Lgraphql/GraphQL;)V", "tableOfContentsElementResolver", "getTableOfContentsElementResolver", "buildSchema", "Lgraphql/schema/GraphQLSchema;", "sdl", "buildWiring", "Lgraphql/schema/idl/RuntimeWiring;", "graphQLErrorHandler", "Lgraphql/kickstart/execution/error/GraphQLErrorHandler;", "instrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "newRuntimeWiring", "block", "Lkotlin/Function1;", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "", "Lkotlin/ExtensionFunctionType;", "schema", "addType", "typeName", "Lgraphql/schema/idl/TypeRuntimeWiring$Builder;", "wiki-service"})
public class GraphQLProvider {
    @NotNull
    private final WikiFetcher wikiFetcher;
    @NotNull
    private final TableOfContentsFetcher tableOfContentsFetcher;
    @NotNull
    private final ArticleFetcher articleFetcher;
    @NotNull
    private final ChapterFetcher chapterFetcher;
    @NotNull
    private final AncestorFetcher ancestorFetcher;
    @NotNull
    private final PermissionFetcher permissionFetcher;
    @NotNull
    private final SubscriptionFetcher subscriptionFetcher;
    @NotNull
    private final UserInfoFetcher userInfoFetcher;
    @NotNull
    private final ProfileInfoFetcher profileInfoFetcher;
    @NotNull
    private final GlobalUserInfoFetcher globalUserInfoFetcher;
    @NotNull
    private final SimpleComplexityCalculator simpleComplexityCalculator;
    private final int maxQueryDepth;
    private final int maxQueryComplexity;
    public GraphQL graphQL;
    @NotNull
    private final DataFetcher<DataFetcherResult<Map<String, Object>>> genericFetcher;
    @NotNull
    private final TypeResolver tableOfContentsElementResolver;
    @NotNull
    private final TypeResolver granteeResolver;

    @Autowired
    public GraphQLProvider(@NotNull WikiFetcher wikiFetcher, @NotNull TableOfContentsFetcher tableOfContentsFetcher, @NotNull ArticleFetcher articleFetcher, @NotNull ChapterFetcher chapterFetcher, @NotNull AncestorFetcher ancestorFetcher, @NotNull PermissionFetcher permissionFetcher, @NotNull SubscriptionFetcher subscriptionFetcher, @NotNull UserInfoFetcher userInfoFetcher, @NotNull ProfileInfoFetcher profileInfoFetcher, @NotNull GlobalUserInfoFetcher globalUserInfoFetcher, @NotNull SimpleComplexityCalculator simpleComplexityCalculator, @Value(value="${service.graphql.maxQueryDepth:7}") int maxQueryDepth, @Value(value="${service.graphql.maxQueryComplexity:10}") int maxQueryComplexity) {
        Intrinsics.checkNotNullParameter((Object)wikiFetcher, (String)"wikiFetcher");
        Intrinsics.checkNotNullParameter((Object)tableOfContentsFetcher, (String)"tableOfContentsFetcher");
        Intrinsics.checkNotNullParameter((Object)articleFetcher, (String)"articleFetcher");
        Intrinsics.checkNotNullParameter((Object)chapterFetcher, (String)"chapterFetcher");
        Intrinsics.checkNotNullParameter((Object)ancestorFetcher, (String)"ancestorFetcher");
        Intrinsics.checkNotNullParameter((Object)permissionFetcher, (String)"permissionFetcher");
        Intrinsics.checkNotNullParameter((Object)subscriptionFetcher, (String)"subscriptionFetcher");
        Intrinsics.checkNotNullParameter((Object)userInfoFetcher, (String)"userInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)profileInfoFetcher, (String)"profileInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)globalUserInfoFetcher, (String)"globalUserInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)simpleComplexityCalculator, (String)"simpleComplexityCalculator");
        this.wikiFetcher = wikiFetcher;
        this.tableOfContentsFetcher = tableOfContentsFetcher;
        this.articleFetcher = articleFetcher;
        this.chapterFetcher = chapterFetcher;
        this.ancestorFetcher = ancestorFetcher;
        this.permissionFetcher = permissionFetcher;
        this.subscriptionFetcher = subscriptionFetcher;
        this.userInfoFetcher = userInfoFetcher;
        this.profileInfoFetcher = profileInfoFetcher;
        this.globalUserInfoFetcher = globalUserInfoFetcher;
        this.simpleComplexityCalculator = simpleComplexityCalculator;
        this.maxQueryDepth = maxQueryDepth;
        this.maxQueryComplexity = maxQueryComplexity;
        this.genericFetcher = GraphQLProvider::genericFetcher$lambda-0;
        this.tableOfContentsElementResolver = GraphQLProvider::tableOfContentsElementResolver$lambda-1;
        this.granteeResolver = GraphQLProvider::granteeResolver$lambda-2;
    }

    @NotNull
    public GraphQL getGraphQL() {
        GraphQL graphQL = this.graphQL;
        if (graphQL != null) {
            return graphQL;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"graphQL");
        throw null;
    }

    public void setGraphQL(@NotNull GraphQL graphQL) {
        Intrinsics.checkNotNullParameter((Object)graphQL, (String)"<set-?>");
        this.graphQL = graphQL;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGraphQL$annotations() {
    }

    @Bean
    @NotNull
    public Instrumentation instrumentation() {
        return (Instrumentation)new ChainedInstrumentation((List)ImmutableList.of((Object)new DataLoaderDispatcherInstrumentation(), (Object)new MaxQueryDepthInstrumentation(this.maxQueryDepth), (Object)new MaxQueryComplexityInstrumentation(this.maxQueryComplexity, (FieldComplexityCalculator)this.simpleComplexityCalculator)));
    }

    @Bean
    @NotNull
    public GraphQLErrorHandler graphQLErrorHandler() {
        return (GraphQLErrorHandler)new CustomGraphQLErrorHandler();
    }

    @Bean
    @NotNull
    public GraphQLSchema schema(@NotNull Instrumentation instrumentation) throws IOException {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        URL url = Resources.getResource((String)"schema.graphql");
        String sdl = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)sdl, (String)"sdl");
        GraphQLSchema graphQLSchema = this.buildSchema(sdl);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).instrumentation(instrumentation).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"newGraphQL(graphQLSchema)\n            .instrumentation(instrumentation)\n            .build()");
        this.setGraphQL(graphQL);
        return graphQLSchema;
    }

    private final GraphQLSchema buildSchema(String sdl) {
        TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(sdl);
        RuntimeWiring runtimeWiring = this.buildWiring();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring)");
        return graphQLSchema;
    }

    private final RuntimeWiring newRuntimeWiring(Function1<? super RuntimeWiring.Builder, Unit> block) {
        boolean $i$f$newRuntimeWiring = false;
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        boolean bl = false;
        boolean bl2 = false;
        block.invoke((Object)builder);
        RuntimeWiring runtimeWiring = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeWiring, (String)"newRuntimeWiring().apply(block).build()");
        return runtimeWiring;
    }

    private final RuntimeWiring.Builder addType(RuntimeWiring.Builder $this$addType, String typeName, Function1<? super TypeRuntimeWiring.Builder, Unit> block) {
        boolean $i$f$addType = false;
        TypeRuntimeWiring.Builder builder = TypeRuntimeWiring.newTypeWiring((String)typeName);
        boolean bl = false;
        boolean bl2 = false;
        block.invoke((Object)builder);
        RuntimeWiring.Builder builder2 = $this$addType.type(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"type(newTypeWiring(typeName).apply(block))");
        return builder2;
    }

    @NotNull
    public DataFetcher<DataFetcherResult<Map<String, Object>>> getGenericFetcher() {
        return this.genericFetcher;
    }

    @NotNull
    public TypeResolver getTableOfContentsElementResolver() {
        return this.tableOfContentsElementResolver;
    }

    @NotNull
    public TypeResolver getGranteeResolver() {
        return this.granteeResolver;
    }

    /*
     * WARNING - void declaration
     */
    private final RuntimeWiring buildWiring() {
        void $this$buildWiring_u24lambda_u2d14_u24lambda_u2d13;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d12;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d11;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d10;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d8;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d7;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3;
        RuntimeWiring.Builder $this$addType$iv;
        GraphQLProvider this_$iv = this;
        boolean $i$f$newRuntimeWiring = false;
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        boolean bl = false;
        boolean bl2 = false;
        RuntimeWiring.Builder $this$buildWiring_u24lambda_u2d14 = builder;
        boolean bl3 = false;
        GraphQLProvider graphQLProvider = this;
        RuntimeWiring.Builder builder2 = $this$buildWiring_u24lambda_u2d14;
        String typeName$iv = "Query";
        boolean $i$f$addType = false;
        TypeRuntimeWiring.Builder builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        TypeRuntimeWiring.Builder builder4 = builder3;
        RuntimeWiring.Builder builder5 = $this$addType$iv;
        boolean bl6 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("wiki", this.wikiFetcher.getById());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("wikis", this.wikiFetcher.getWikis());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getById());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("article", this.articleFetcher.getById());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("articleVersion", this.articleFetcher.getByVersionId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("chapter", this.chapterFetcher.getById());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3.dataFetcher("globalUserInfo", this.getGenericFetcher());
        Unit unit = Unit.INSTANCE;
        RuntimeWiring.Builder builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        GraphQLProvider this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "Mutation";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d3 = builder3;
        builder5 = $this$addType$iv;
        boolean bl7 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("createWiki", this.wikiFetcher.getCreate());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("updateWiki", this.wikiFetcher.getUpdate());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("deleteWiki", this.wikiFetcher.getDelete());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("createArticle", this.articleFetcher.create());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("updateArticle", this.articleFetcher.update());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("deleteArticle", this.articleFetcher.delete());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("updateArticleEditingToken", this.articleFetcher.updateEditingToken());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("deleteArticleEditingToken", this.articleFetcher.deleteEditingToken());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("updateTableOfContents", this.tableOfContentsFetcher.update());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("createChapter", this.chapterFetcher.create());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("updateChapter", this.chapterFetcher.update());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("deleteChapter", this.chapterFetcher.delete());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4.dataFetcher("setSubscription", this.subscriptionFetcher.getSetSubscription());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "Wiki";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d4 = builder3;
        builder5 = $this$addType$iv;
        boolean bl8 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("articles", this.articleFetcher.getAllByWiki());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("articleCount", this.articleFetcher.getCountByWiki());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("chapterCount", this.chapterFetcher.getCountByWiki());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("chapters", this.chapterFetcher.getAllByWiki());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getByWikiId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("permissions", this.permissionFetcher.getPermissions());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("userInfo", this.getGenericFetcher());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("contactPerson", this.profileInfoFetcher.getGetContactPerson());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "Chapter";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d5 = builder3;
        builder5 = $this$addType$iv;
        boolean bl9 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("articles", this.articleFetcher.getAllByChapter());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("chapters", this.chapterFetcher.getAllByChapter());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("ancestors", this.ancestorFetcher.getByChapterId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getByChapterId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6.dataFetcher("wiki", this.wikiFetcher.getByChapterId());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "UserInfo";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d6 = builder3;
        builder5 = $this$addType$iv;
        boolean bl10 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d7.dataFetcher("isManager", this.userInfoFetcher.isManager());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d7.dataFetcher("isWriter", this.userInfoFetcher.isWriter());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d7.dataFetcher("isSubscribed", this.userInfoFetcher.isSubscribed());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "GlobalUserInfo";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d7 = builder3;
        builder5 = $this$addType$iv;
        boolean bl11 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d8.dataFetcher("mayCreateWiki", this.globalUserInfoFetcher.getMayCreateWiki());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "Article";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d8 = builder3;
        builder5 = $this$addType$iv;
        boolean bl12 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9.dataFetcher("ancestors", this.ancestorFetcher.getByArticleId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9.dataFetcher("wiki", this.wikiFetcher.getByArticleId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9.dataFetcher("articleVersions", this.articleFetcher.getArticleVersionsByArticleId());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9.dataFetcher("contactPerson", this.profileInfoFetcher.getGetContactPerson());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "PermissionType";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d9 = builder3;
        builder5 = $this$addType$iv;
        boolean bl13 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d10.enumValues((EnumValuesProvider)new NaturalEnumValuesProvider(PermissionType.class));
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "TableOfContentsElement";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d10 = builder3;
        builder5 = $this$addType$iv;
        boolean bl14 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d11.typeResolver(this.getTableOfContentsElementResolver());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "Grantee";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d11 = builder3;
        builder5 = $this$addType$iv;
        boolean bl15 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d12.typeResolver(this.getGranteeResolver());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2d14;
        typeName$iv = "ArticleVersion";
        $i$f$addType = false;
        builder3 = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        bl4 = false;
        bl5 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d12 = builder3;
        builder5 = $this$addType$iv;
        boolean bl16 = false;
        $this$buildWiring_u24lambda_u2d14_u24lambda_u2d13.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        unit = Unit.INSTANCE;
        builder6 = builder5.type(builder3);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"type(newTypeWiring(typeName).apply(block))");
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getWIKI_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getARTICLE_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getARTICLE_VERSION_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getCHAPTER_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getPARENT_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getTENANT_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getPERMISSION_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getITEM_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getGRANTEE_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(GraphQLScalar.INSTANCE.getPROFILE_ID());
        $this$buildWiring_u24lambda_u2d14.scalar(ExtendedScalars.DateTime);
        RuntimeWiring runtimeWiring = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeWiring, (String)"newRuntimeWiring().apply(block).build()");
        return runtimeWiring;
    }

    private static final DataFetcherResult genericFetcher$lambda-0(DataFetchingEnvironment env) {
        return DataFetcherResult.newResult().data((Object)MapsKt.emptyMap()).localContext(env.getSource()).build();
    }

    private static final GraphQLObjectType tableOfContentsElementResolver$lambda-1(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        Object object2 = object;
        return object2 instanceof TableOfContentsArticleDto ? env.getSchema().getObjectType("TableOfContentsArticle") : (object2 instanceof TableOfContentsChapterDto ? env.getSchema().getObjectType("TableOfContentsChapter") : null);
    }

    private static final GraphQLObjectType granteeResolver$lambda-2(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        Object object2 = object;
        return object2 instanceof ProfileGranteeDto ? env.getSchema().getObjectType("ProfileGrantee") : (object2 instanceof GroupGranteeDto ? env.getSchema().getObjectType("GroupGrantee") : null);
    }
}

