/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.search.SolrService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0017J\b\u0010\u0012\u001a\u00020\u0010H\u0017J\b\u0010\u0013\u001a\u00020\u0010H\u0017J\b\u0010\u0014\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/controller/InternalWikiController;", "", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "solrService", "Lde/justsoftware/wikiservice/search/SolrService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "(Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/search/SolrService;Lde/justsoftware/wikiservice/business/WikiService;)V", "getWikiNamesByIds", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "ids", "", "publishAllPermissions", "", "reindexAll", "reindexArticles", "reindexChapters", "reindexWikis", "wiki-service"})
public class InternalWikiController {
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final SolrService solrService;
    @NotNull
    private final WikiService wikiService;

    public InternalWikiController(@NotNull PermissionApplicationService permissionApplicationService, @NotNull SolrService solrService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)solrService, (String)"solrService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.permissionApplicationService = permissionApplicationService;
        this.solrService = solrService;
        this.wikiService = wikiService;
    }

    @PostMapping(value={"publish/permissions"})
    public void publishAllPermissions() {
        this.permissionApplicationService.republishPermissions();
    }

    @PostMapping(value={"search/reindexAll"})
    public void reindexAll() {
        this.solrService.reindexAll();
    }

    @PostMapping(value={"search/reindexWikis"})
    public void reindexWikis() {
        this.solrService.reindexWikis();
    }

    @PostMapping(value={"search/reindexChapters"})
    public void reindexChapters() {
        this.solrService.reindexChapters();
    }

    @PostMapping(value={"search/reindexArticles"})
    public void reindexArticles() {
        this.solrService.reindexArticles();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"wikiNamesByIds"})
    @NotNull
    public Map<WikiId, String> getWikiNamesByIds(@RequestBody @NotNull Set<? extends WikiId> ids) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Map $this$mapValues$iv = this.wikiService.readByIds(CollectionsKt.toSet((Iterable)ids));
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            String string = ((WikiDto)it.getValue()).getTitle();
            map3.put(k2, string);
        }
        return destination$iv$iv;
    }
}

