/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.wikiservice.config.security.oAuth.JustOpaqueTokenIntrospector;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@EnableWebSecurity
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BA\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/config/security/WebSecurityConfiguration;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "toroBaseUrl", "", "checkTokenEndpoint", "clientId", "clientSecret", "maxAccessTokenCacheSize", "", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLde/justsoftware/jwtfilter/verifier/JwtVerifier;)V", "internalApi", "configure", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "wiki-service"})
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final String checkTokenEndpoint;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    private final long maxAccessTokenCacheSize;
    @NotNull
    private final JwtVerifier jwtVerifier;
    @NotNull
    private final String internalApi;

    @Autowired
    public WebSecurityConfiguration(@Value(value="${just.wiki.toro.internal.baseUrl}") @NotNull String toroBaseUrl, @Value(value="${just.wiki.oauth2.resource.check_token_endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.wiki.oauth2.resource.client_id}") @NotNull String clientId, @Value(value="${just.wiki.oauth2.resource.client_secret}") @NotNull String clientSecret, @Value(value="${just.wiki.oauth2.resource.accessTokenCache.maxSize: 1000}") long maxAccessTokenCacheSize, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        super(true);
        this.toroBaseUrl = toroBaseUrl;
        this.checkTokenEndpoint = checkTokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.maxAccessTokenCacheSize = maxAccessTokenCacheSize;
        this.jwtVerifier = jwtVerifier;
        this.internalApi = "/internal/**";
    }

    protected void configure(@NotNull HttpSecurity http) throws Exception {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        JwtAuthenticationProcessingFilter jwt = new JwtAuthenticationProcessingFilter(this.jwtVerifier);
        jwt.applyIgnoreFilterMatcher(arg_0 -> WebSecurityConfiguration.configure$lambda-0(this, arg_0));
        String[] stringArray = new String[]{this.internalApi};
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().and()).anonymous().and()).headers().cacheControl().and().and()).authorizeRequests().antMatchers(stringArray)).permitAll().and()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.configure$lambda-2(this, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
    }

    private static final boolean configure$lambda-0(WebSecurityConfiguration this$0, HttpServletRequest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new AntPathRequestMatcher(this$0.internalApi).matches(it);
    }

    private static final void configure$lambda-2$lambda-1(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector(this$0.toroBaseUrl + this$0.checkTokenEndpoint, this$0.clientId, this$0.clientSecret, this$0.maxAccessTokenCacheSize);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void configure$lambda-2(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.configure$lambda-2$lambda-1(this$0, arg_0));
    }
}

