/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.wikiservice.business.DeletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/config/DeletionCleaningScheduler;", "", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxDeletionAgeInHours", "", "(Lde/justsoftware/wikiservice/business/DeletionService;J)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "executorFactory", "Ljava/util/concurrent/ThreadFactory;", "logger", "Lorg/slf4j/Logger;", "maxAgeInSeconds", "name", "", "scheduledThread", "Ljava/util/concurrent/ScheduledFuture;", "destroy", "", "wiki-service"})
public class DeletionCleaningScheduler {
    @NotNull
    private final DeletionService deletionService;
    private final long maxAgeInSeconds;
    private final Logger logger;
    @NotNull
    private final String name;
    private final ThreadFactory executorFactory;
    private final ScheduledExecutorService executor;
    @Nullable
    private final ScheduledFuture<?> scheduledThread;

    @Autowired
    public DeletionCleaningScheduler(@NotNull DeletionService deletionService, @Value(value="${service.maxDeletionAge:-1}") long maxDeletionAgeInHours) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.deletionService = deletionService;
        this.maxAgeInSeconds = TimeUnit.SECONDS.convert(maxDeletionAgeInHours, TimeUnit.HOURS);
        this.logger = LoggerFactory.getLogger(DeletionCleaningScheduler.class);
        this.name = "DeletionCleaningThread";
        this.executorFactory = new ThreadFactoryBuilder().setNameFormat("ThreadScheduledExecutor-" + this.name + "-%d").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(this.executorFactory);
        if (this.maxAgeInSeconds <= 0L) {
            this.logger.info(this.name + " is deactivated in config via service.maxDeletionAge");
            scheduledFuture = null;
        } else {
            this.logger.info("Scheduling " + this.name + " with maxDeletionAge " + this.maxAgeInSeconds + " seconds");
            scheduledFuture = this.executor.scheduleAtFixedRate(() -> DeletionCleaningScheduler.scheduledThread$lambda-0(this), TimeUnit.MINUTES.toSeconds(1L), 1L, TimeUnit.HOURS);
        }
        this.scheduledThread = scheduledFuture;
    }

    @PreDestroy
    public void destroy() {
        if (this.scheduledThread != null && !this.scheduledThread.isCancelled()) {
            this.logger.info("Cancelling " + this.name);
            this.scheduledThread.cancel(true);
        }
        this.executor.shutdown();
    }

    private static final void scheduledThread$lambda-0(DeletionCleaningScheduler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.logger.info("Executing " + this$0.name);
            this$0.deletionService.removeOldDeletions(this$0.maxAgeInSeconds);
        }
        catch (Exception ex) {
            this$0.logger.error("Error while running " + this$0.name, (Throwable)ex);
        }
    }
}

