/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.kafka.MultiRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsetException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.UserGroupService;
import de.justsoftware.wikiservice.business.exceptions.MissingManagerPermissionException;
import de.justsoftware.wikiservice.business.exceptions.NoGranteeException;
import de.justsoftware.wikiservice.business.exceptions.PermissionNotFoundException;
import de.justsoftware.wikiservice.business.model.Grantee;
import de.justsoftware.wikiservice.business.model.GroupGranteeDto;
import de.justsoftware.wikiservice.business.model.PermissionDto;
import de.justsoftware.wikiservice.business.model.ProfileDto;
import de.justsoftware.wikiservice.business.model.ProfileGranteeDto;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.PermissionId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.PermissionRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.Permission;
import de.justsoftware.wikiservice.persistence.model.UserGroup;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.KotlinUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0017\u0018\u0000 J2\u00020\u0001:\u0002JKBO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0017J$\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J$\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J0\u0010+\u001a\b\u0012\u0004\u0012\u00020$0,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u0002000,0.H\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000200H\u0017J\u0016\u00103\u001a\u00020\u00192\f\u00104\u001a\b\u0012\u0004\u0012\u0002050,H\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020*0,2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0,0.2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001d09H\u0016J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0016\u0010<\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001d09H\u0017J\u0016\u0010=\u001a\u00020\u00192\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0,H\u0002J\b\u0010@\u001a\u00020\u0019H\u0016J\b\u0010A\u001a\u00020\u0019H\u0002J\u0016\u0010B\u001a\u00020\u00192\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0,H\u0002J0\u0010E\u001a\b\u0012\u0004\u0012\u00020*0,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u0002000,0.H\u0017J\"\u0010F\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020*0.2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020$0HH\u0002J*\u0010I\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u0002000,0.H\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lde/justsoftware/wikiservice/business/PermissionService;", "", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "userGroupService", "Lde/justsoftware/wikiservice/business/UserGroupService;", "multiRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "permissionRepository", "Lde/justsoftware/wikiservice/persistence/PermissionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/business/UserGroupService;Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;Lde/justsoftware/permission/client/kafka/PermissionItemProducer;Lde/justsoftware/wikiservice/persistence/PermissionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addPermissionItemForNewArticle", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "addPermissionItemForNewWiki", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "createGrantee", "Lde/justsoftware/wikiservice/business/model/Grantee;", "permission", "Lde/justsoftware/wikiservice/persistence/model/Permission;", "profile", "Lde/justsoftware/wikiservice/business/model/ProfileDto;", "userGroup", "Lde/justsoftware/wikiservice/persistence/model/UserGroup;", "createPermissionDto", "Lde/justsoftware/wikiservice/business/model/PermissionDto;", "createPermissions", "", "permissions", "", "Lde/justsoftware/wikiservice/model/PermissionType;", "Lde/justsoftware/wikiservice/model/GranteeId;", "deletePermissionsForGrantee", "granteeId", "executePermissionInstructions", "instructions", "Lde/justsoftware/wikiservice/business/PermissionService$PermissionInstruction;", "getPermissionsByWikiId", "getPermissionsByWikiIds", "wikiIds", "", "removePermissionsForDeletedArticle", "removePermissionsForDeletedWiki", "removePermissionsForWikis", "republishArticleItems", "articles", "Lde/justsoftware/wikiservice/persistence/model/Article;", "republishPermissions", "republishRoles", "republishWikiItems", "wikis", "Lde/justsoftware/wikiservice/persistence/model/Wiki;", "setPermissions", "toPermissionDtos", "Lde/justsoftware/wikiservice/model/PermissionId;", "", "validatePermissions", "Companion", "PermissionInstruction", "wiki-service"})
public class PermissionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final MultiRoleAssignmentProducer multiRoleAssignmentProducer;
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private final PermissionRepository permissionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Logger log;

    @Autowired
    public PermissionService(@NotNull ProfileService profileService, @NotNull WikiRepository wikiRepository, @NotNull ArticleRepository articleRepository, @NotNull UserGroupService userGroupService, @NotNull MultiRoleAssignmentProducer multiRoleAssignmentProducer, @NotNull PermissionItemProducer permissionItemProducer, @NotNull PermissionRepository permissionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)multiRoleAssignmentProducer, (String)"multiRoleAssignmentProducer");
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileService = profileService;
        this.wikiRepository = wikiRepository;
        this.articleRepository = articleRepository;
        this.userGroupService = userGroupService;
        this.multiRoleAssignmentProducer = multiRoleAssignmentProducer;
        this.permissionItemProducer = permissionItemProducer;
        this.permissionRepository = permissionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.log = LoggerFactory.getLogger(PermissionService.class);
    }

    @Transactional
    public void addPermissionItemForNewArticle(@NotNull ArticleId articleId, @NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void addPermissionItemForNewWiki(@NotNull WikiId wikiId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void removePermissionsForDeletedWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void removePermissionsForDeletedArticle(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deletePermissionsForGrantee(@NotNull GranteeId granteeId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List permissionsToRemove = this.permissionRepository.findAllByGranteeId(granteeId);
        if (permissionsToRemove.isEmpty()) {
            return;
        }
        Iterable iterable = permissionsToRemove;
        boolean $i$f$mapNotNull22 = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PermissionId permissionId;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Permission it = (Permission)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PermissionId it$iv$iv = permissionId;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set permissionsIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$mapNotNull22 = permissionsToRemove;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Permission)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            WikiId wikiId = it.getWikiId();
            collection.add(wikiId);
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.permissionRepository.deleteAllById(permissionsIds);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Permission> createPermissions(WikiId wikiId, Map<PermissionType, ? extends List<? extends GranteeId>> permissions) {
        void $this$flatMapTo$iv$iv;
        Map<PermissionType, ? extends List<? extends GranteeId>> $this$flatMap$iv = permissions;
        boolean $i$f$flatMap = false;
        Map<PermissionType, ? extends List<? extends GranteeId>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var9_8 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$permissionType$granteeIds = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$permissionType$granteeIds;
            boolean bl3 = false;
            PermissionType permissionType = (PermissionType)entry.getKey();
            Map.Entry entry2 = $dstr$permissionType$granteeIds;
            boolean bl4 = false;
            List granteeIds = (List)entry2.getValue();
            Iterable $this$map$iv = granteeIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GranteeId granteeId = (GranteeId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                Permission permission = new Permission(wikiId, permissionType, (GranteeId)it);
                collection.add(permission);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newPermissions = (List)destination$iv$iv;
        List list = this.permissionRepository.saveAll((Iterable)newPermissions);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"permissionRepository.saveAll(newPermissions)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePermissions(WikiId wikiId, Map<PermissionType, ? extends List<? extends GranteeId>> permissions) {
        void $this$filterTo$iv$iv;
        if (!permissions.containsKey(PermissionType.MANAGER) || ((List)MapsKt.getValue(permissions, (Object)PermissionType.MANAGER)).isEmpty()) {
            throw new MissingManagerPermissionException(wikiId);
        }
        Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)permissions.values());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GranteeId it = (GranteeId)element$iv$iv;
            boolean bl = false;
            if (!(!it.isProfileOrUserGroup())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsupportedGranteeIds = (List)destination$iv$iv;
        boolean bl = unsupportedGranteeIds.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Following granteeIds are not supported (required User Group or Profile):\n" + unsupportedGranteeIds;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Transactional
    @NotNull
    public List<PermissionDto> setPermissions(@NotNull WikiId wikiId, @NotNull Map<PermissionType, ? extends List<? extends GranteeId>> permissions) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.log.debug("Validating new permissions for " + wikiId);
        this.validatePermissions(wikiId, permissions);
        this.log.debug("Deleting previous permissions for wiki " + wikiId);
        this.permissionRepository.deleteByWikiId(wikiId);
        this.permissionRepository.flush();
        this.log.debug("Creating new permissions for wiki " + wikiId + " in database");
        List createdPermissions = this.createPermissions(wikiId, permissions);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)createdPermissions).values());
    }

    public void republishPermissions() {
        List wikis = this.wikiRepository.findAll();
        List articles = this.articleRepository.findAll();
        this.log.debug("Republishing permission items for wikis");
        Intrinsics.checkNotNullExpressionValue((Object)wikis, (String)"wikis");
        this.republishWikiItems(wikis);
        Intrinsics.checkNotNullExpressionValue((Object)articles, (String)"articles");
        this.republishArticleItems(articles);
        this.log.debug("Republishing role replacements");
        this.republishRoles();
    }

    private final void republishRoles() {
        this.multiRoleAssignmentProducer.republishForItemRoles(IdType.WIKI_WIKI.name(), PermissionType.Companion.getTypes(), () -> PermissionService.republishRoles$lambda-9(this));
    }

    private final void republishWikiItems(List<? extends Wiki> wikis) {
        this.permissionItemProducer.republish(IdType.WIKI_WIKI.name(), () -> PermissionService.republishWikiItems$lambda-11(wikis, this));
    }

    private final void republishArticleItems(List<? extends Article> articles) {
        this.permissionItemProducer.republish(IdType.WIKI_ARTICLE.name(), () -> PermissionService.republishArticleItems$lambda-13(articles, this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, List<PermissionDto>> getPermissionsByWikiIds(@NotNull Set<? extends WikiId> wikiIds) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map wikiPermissions = this.permissionRepository.findAllByWikiIds(wikiIds);
        Map permissionDtos = this.toPermissionDtos((Collection)CollectionsKt.flatten((Iterable)wikiPermissions.values()));
        Map $this$mapValues$iv = wikiPermissions;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $dstr$_u24__u24$permissions;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            void var19_19 = $dstr$_u24__u24$permissions;
            boolean bl3 = false;
            List permissions = (List)var19_19.getValue();
            Iterable $this$mapNotNull$iv = permissions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PermissionDto permissionDto;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                boolean bl4 = false;
                Permission it = (Permission)element$iv$iv;
                boolean bl5 = false;
                Map map4 = permissionDtos;
                PermissionId permissionId = it.getId();
                boolean bl6 = false;
                if ((PermissionDto)map4.get(permissionId) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                PermissionDto it$iv$iv2 = permissionDto;
                boolean bl9 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map3.put(k2, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public List<PermissionDto> getPermissionsByWikiId(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        List wikiPermissions = this.permissionRepository.findAllByWikiIds(SetsKt.setOf((Object)wikiId)).getOrDefault(wikiId, CollectionsKt.emptyList());
        return CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)wikiPermissions).values());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PermissionId, PermissionDto> toPermissionDtos(Collection<? extends Permission> permissions) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean bl;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Iterable iterable = permissions;
        Object object = this.profileService;
        boolean $i$f$mapNotNull22 = false;
        void var5_6 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId profileId;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl2 = false;
            Permission it = (Permission)element$iv$iv;
            boolean bl3 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl4 = false;
            bl = false;
            ProfileId it$iv$iv = profileId;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map profiles = object.readByIds(CollectionsKt.toSet((Iterable)list));
        Iterable $i$f$mapNotNull22 = permissions;
        object = this.userGroupService;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId userGroupId;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl6 = false;
            Permission it = (Permission)element$iv$iv;
            boolean bl7 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            bl = false;
            boolean bl8 = false;
            UserGroupId it$iv$iv = userGroupId;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        list = (List)destination$iv$iv2;
        Map userGroups = object.readByIds(CollectionsKt.toSet((Iterable)list));
        Iterable $this$map$iv = permissions;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv2 = (Permission)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl10 = false;
            Object object2 = it.getId();
            if (object2 == null) {
                throw new PermissionNotFoundException(null, 1, null);
            }
            PermissionId permissionId = object2;
            object2 = profiles;
            ProfileId profileId = it.getGranteeId().toProfileId();
            boolean bl11 = false;
            ProfileDto profileDto = (ProfileDto)object2.get(profileId);
            object2 = userGroups;
            profileId = it.getGranteeId().toUserGroupId();
            bl11 = false;
            list = TuplesKt.to((Object)permissionId, (Object)this.createPermissionDto((Permission)it, profileDto, (UserGroup)object2.get(profileId)));
            object.add(list);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
    }

    private final PermissionDto createPermissionDto(Permission permission, ProfileDto profile, UserGroup userGroup) {
        PermissionId permissionId = permission.getId();
        if (permissionId == null) {
            throw new PermissionNotFoundException(null, 1, null);
        }
        return new PermissionDto(permissionId, permission.getWikiId(), permission.getType(), this.createGrantee(permission, profile, userGroup));
    }

    private final Grantee createGrantee(Permission permission, ProfileDto profile, UserGroup userGroup) {
        Grantee grantee;
        if (userGroup != null) {
            grantee = (Grantee)new GroupGranteeDto(permission.getGranteeId(), userGroup.getName(), userGroup.isAllTenantUsersGroup());
        } else if (profile != null) {
            grantee = (Grantee)new ProfileGranteeDto(permission.getGranteeId(), profile.getFullName(), StringsKt.replace$default((String)profile.getImageUrl(), (String)"/original/", (String)"/small/", (boolean)false, (int)4, null), profile.getStatus());
        } else {
            throw new NoGranteeException(permission.getId());
        }
        return grantee;
    }

    private final void executePermissionInstructions(List<? extends PermissionInstruction> instructions) {
        Stream.Builder<WaitForOffsets> offsetConsumer = Stream.builder();
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PermissionInstruction it = (PermissionInstruction)element$iv;
            boolean bl = false;
            PermissionInstruction permissionInstruction = it;
            if (permissionInstruction instanceof PermissionInstruction.AddWikiInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishItem(((PermissionInstruction.AddWikiInstruction)it).getWikiId().toString(), Optional.of(((PermissionInstruction.AddWikiInstruction)it).getTenantId().toString()), new String[0]));
            } else if (permissionInstruction instanceof PermissionInstruction.DeleteItemInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishDeletedItem(((PermissionInstruction.DeleteItemInstruction)it).getItemId().toString()));
            } else if (permissionInstruction instanceof PermissionInstruction.PublishReplacementsInstruction) {
                offsetConsumer.accept(this.multiRoleAssignmentProducer.publishRoleReplacements(((PermissionInstruction.PublishReplacementsInstruction)it).getReplacements()));
            } else if (permissionInstruction instanceof PermissionInstruction.AddArticleInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishItem(((PermissionInstruction.AddArticleInstruction)it).getArticleId().toString(), Optional.of(((PermissionInstruction.AddArticleInstruction)it).getWikiId().toString()), new String[0]));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            KotlinUtilsKt.getCheckAllMatched((Object)Unit.INSTANCE);
        }
        try {
            new WaitForOffsets(offsetConsumer.build()).waitForOffsets();
        }
        catch (WaitForOffsetException ex) {
            this.log.error("error while waiting for response from permission service", (Throwable)ex);
        }
    }

    @Transactional
    public void removePermissionsForWikis(@NotNull Set<? extends WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.permissionRepository.deleteAllByWikiIds(wikiIds);
    }

    /*
     * WARNING - void declaration
     */
    private static final void republishRoles$lambda-9(PermissionService this$0) {
        void $this$mapValuesTo$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$groupBy$iv = this$0.permissionRepository.findAllForActiveWikis();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            Permission permission = (Permission)element$iv$iv;
            boolean bl = false;
            key$iv$iv = Companion.permissionRole(permission.getWikiId(), permission.getType());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void permission;
                Permission permission2 = (Permission)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Role role = permission.getGranteeId().toRole();
                collection.add(role);
            }
            List list = (List)destination$iv$iv2;
            map2.put(k2, list);
        }
        Map roleReplacements = destination$iv$iv;
        this$0.multiRoleAssignmentProducer.publishRoleReplacements(roleReplacements);
    }

    private static final void republishWikiItems$lambda-11(List $wikis, PermissionService this$0) {
        Intrinsics.checkNotNullParameter((Object)$wikis, (String)"$wikis");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $wikis;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Wiki it = (Wiki)element$iv;
            boolean bl = false;
            this$0.permissionItemProducer.publishItem(String.valueOf(it.getId()), Optional.of(it.getTenantId().toString()), new String[0]);
        }
    }

    private static final void republishArticleItems$lambda-13(List $articles, PermissionService this$0) {
        Intrinsics.checkNotNullParameter((Object)$articles, (String)"$articles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $articles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this$0.permissionItemProducer.publishItem(String.valueOf(it.getId()), Optional.of(it.getWikiId().toString()), new String[0]);
        }
    }

    public static final /* synthetic */ void access$executePermissionInstructions(PermissionService $this, List instructions) {
        $this.executePermissionInstructions(instructions);
    }

    public static final /* synthetic */ Logger access$getLog$p(PermissionService $this) {
        return $this.log;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(PermissionService $this) {
        return $this.applicationEventPublisher;
    }
}

