/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.DriveFileMigrationService;
import de.justsoftware.wikiservice.kafka.DriveFileMigrationProducer;
import de.justsoftware.wikiservice.kafka.model.DriveFileMigrationResult;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ClusterPosition;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.DriveFileMigrationRepository;
import de.justsoftware.wikiservice.persistence.MigrationStatusRepository;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.DriveFileMigration;
import de.justsoftware.wikiservice.persistence.model.MigrationState;
import de.justsoftware.wikiservice.persistence.model.MigrationStatus;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0017J\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0016\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lde/justsoftware/wikiservice/business/DriveFileMigrationService;", "", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "driveFileMigrationRepository", "Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;", "migrationStatusRepository", "Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;", "driveFileMigrationProducer", "Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;", "driveFileMigrationBatchSize", "", "clusterPosition", "Lde/justsoftware/wikiservice/model/ClusterPosition;", "(Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;ILde/justsoftware/wikiservice/model/ClusterPosition;)V", "getArticleVersionRepository", "()Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "getClusterPosition", "()Lde/justsoftware/wikiservice/model/ClusterPosition;", "getDriveFileMigrationProducer", "()Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;", "getDriveFileMigrationRepository", "()Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMigrationStatusRepository", "()Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;", "migrate", "", "runAfterStart", "saveMigrations", "driveFileMigrations", "", "Lde/justsoftware/wikiservice/persistence/model/DriveFileMigration;", "updateDriveMediaIds", "migrationResults", "Lde/justsoftware/wikiservice/kafka/model/DriveFileMigrationResult;", "Companion", "wiki-service"})
public class DriveFileMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final DriveFileMigrationRepository driveFileMigrationRepository;
    @NotNull
    private final MigrationStatusRepository migrationStatusRepository;
    @NotNull
    private final DriveFileMigrationProducer driveFileMigrationProducer;
    private final int driveFileMigrationBatchSize;
    @NotNull
    private final ClusterPosition clusterPosition;
    private final Logger logger;
    @NotNull
    private static final String MIGRATION_ID = "DRIVE_FILES";

    @Autowired
    public DriveFileMigrationService(@NotNull ArticleVersionRepository articleVersionRepository, @NotNull DriveFileMigrationRepository driveFileMigrationRepository, @NotNull MigrationStatusRepository migrationStatusRepository, @NotNull DriveFileMigrationProducer driveFileMigrationProducer, @Value(value="${service.driveFileMigrationBatchSize:100}") int driveFileMigrationBatchSize, @NotNull ClusterPosition clusterPosition) {
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)driveFileMigrationRepository, (String)"driveFileMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationStatusRepository, (String)"migrationStatusRepository");
        Intrinsics.checkNotNullParameter((Object)driveFileMigrationProducer, (String)"driveFileMigrationProducer");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        this.articleVersionRepository = articleVersionRepository;
        this.driveFileMigrationRepository = driveFileMigrationRepository;
        this.migrationStatusRepository = migrationStatusRepository;
        this.driveFileMigrationProducer = driveFileMigrationProducer;
        this.driveFileMigrationBatchSize = driveFileMigrationBatchSize;
        this.clusterPosition = clusterPosition;
        this.logger = LoggerFactory.getLogger(DriveFileMigrationService.class);
    }

    @NotNull
    public ArticleVersionRepository getArticleVersionRepository() {
        return this.articleVersionRepository;
    }

    @NotNull
    public DriveFileMigrationRepository getDriveFileMigrationRepository() {
        return this.driveFileMigrationRepository;
    }

    @NotNull
    public MigrationStatusRepository getMigrationStatusRepository() {
        return this.migrationStatusRepository;
    }

    @NotNull
    public DriveFileMigrationProducer getDriveFileMigrationProducer() {
        return this.driveFileMigrationProducer;
    }

    @NotNull
    public ClusterPosition getClusterPosition() {
        return this.clusterPosition;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void runAfterStart() {
        if (this.getClusterPosition() != ClusterPosition.PRIMARY) {
            return;
        }
        this.migrate();
    }

    /*
     * WARNING - void declaration
     */
    public void migrate() {
        Object t = this.getMigrationStatusRepository().findById((Object)MIGRATION_ID).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"migrationStatusRepository.findById(MIGRATION_ID).get()");
        MigrationStatus migration = (MigrationStatus)t;
        if (migration.getStatus() == MigrationState.FINISHED) {
            return;
        }
        Instant instant = migration.getCreatedAt();
        Instant before = instant == null ? Instant.now() : instant;
        Instant instant2 = migration.getUpdatedAt();
        Instant after = instant2 == null ? Instant.EPOCH : instant2;
        String[] stringArray = new String[]{"createdAt"};
        PageRequest page = PageRequest.of((int)0, (int)this.driveFileMigrationBatchSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        ArticleVersionRepository articleVersionRepository = this.getArticleVersionRepository();
        Intrinsics.checkNotNullExpressionValue((Object)after, (String)"after");
        Intrinsics.checkNotNullExpressionValue((Object)before, (String)"before");
        PageRequest pageRequest = page;
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"page");
        Page pagedResult = articleVersionRepository.findAllByCreatedAtAfterAndCreatedAtBefore(after, before, (Pageable)pageRequest);
        while (!pagedResult.isEmpty()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void $this$flatMapTo$iv$iv;
            Collection collection = pagedResult.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"pagedResult.content");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable $this$map$iv;
                ArticleVersion it = (ArticleVersion)element$iv$iv;
                boolean bl = false;
                try {
                    void $this$mapTo$iv$iv;
                    $this$map$iv = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)it.getContent());
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void driveFileId;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        DriveFileMigration driveFileMigration = new DriveFileMigration((String)driveFileId, null, it.getArticleId());
                        collection2.add(driveFileMigration);
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                }
                catch (Exception ex) {
                    this.logger.error("Could not extract driveIds for ArticleVersion " + it.getId() + ": " + ex.getClass());
                    $this$map$iv = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = $this$map$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DriveFileMigration bl = (DriveFileMigration)element$iv$iv;
                Map map = destination$iv$iv3;
                boolean bl3 = false;
                String string = it.getOldFileId();
                map.put(string, element$iv$iv);
            }
            Set driveFileIds = CollectionsKt.toSet((Iterable)destination$iv$iv3.values());
            collection = driveFileIds;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.saveMigrations(driveFileIds);
                migration.setUpdatedAt(Instant.now());
                this.getMigrationStatusRepository().saveAndFlush((Object)migration);
            }
            page = page.next();
            ArticleVersionRepository articleVersionRepository2 = this.getArticleVersionRepository();
            collection = page;
            Intrinsics.checkNotNullExpressionValue(collection, (String)"page");
            pagedResult = articleVersionRepository2.findAllByCreatedAtAfterAndCreatedAtBefore(after, before, (Pageable)collection);
        }
        migration.setStatus(MigrationState.FINISHED);
        this.getMigrationStatusRepository().saveAndFlush((Object)migration);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveMigrations(Set<? extends DriveFileMigration> driveFileMigrations) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = driveFileMigrations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DriveFileMigration driveFileMigration = (DriveFileMigration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getOldFileId();
            collection.add(string);
        }
        Set driveFileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set existingMigrations = this.getDriveFileMigrationRepository().findByDriveFileIds(driveFileIds);
        Set newMigrations = SetsKt.minus(driveFileMigrations, (Iterable)existingMigrations);
        this.getDriveFileMigrationProducer().sendDriveFileMigrations(newMigrations);
        this.getDriveFileMigrationRepository().saveAllAndFlush((Iterable)newMigrations);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateDriveMediaIds(@NotNull Set<DriveFileMigrationResult> migrationResults) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        String newFileId;
        Object articleId;
        Object element$iv2;
        String string;
        Object object;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        DriveFileMigrationResult it2;
        void $this$associateTo$iv$iv2;
        Intrinsics.checkNotNullParameter(migrationResults, (String)"migrationResults");
        Iterable $this$associate$iv2 = migrationResults;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv2;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            it2 = (DriveFileMigrationResult)element$iv$iv;
            boolean bl = false;
            it2 = TuplesKt.to((Object)it2.getOldFileId(), (Object)it2.getNewFileId());
            bl = false;
            map.put(it2.getFirst(), it2.getSecond());
        }
        Map idMapping = destination$iv$iv;
        Iterable $i$f$associate22 = this.getDriveFileMigrationRepository().findByDriveFileIds(idMapping.keySet());
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it2 = (DriveFileMigration)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            string = it2.getOldFileId();
            object.put(string, element$iv$iv);
        }
        Map migrationsMapping = MapsKt.toMutableMap((Map)destination$iv$iv2);
        Iterable $this$forEach$iv2 = migrationResults;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            DriveFileMigrationResult $dstr$articleId$oldFileId$newFileId = (DriveFileMigrationResult)element$iv2;
            boolean bl = false;
            articleId = $dstr$articleId$oldFileId$newFileId.component1();
            String oldFileId = $dstr$articleId$oldFileId$newFileId.component2();
            newFileId = $dstr$articleId$oldFileId$newFileId.component3();
            migrationsMapping.computeIfAbsent(oldFileId, arg_0 -> DriveFileMigrationService.updateDriveMediaIds$lambda-7$lambda-6(oldFileId, newFileId, (ArticleId)articleId, arg_0));
        }
        $this$forEach$iv2 = migrationsMapping.values();
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            DriveFileMigration it3 = (DriveFileMigration)element$iv2;
            boolean bl = false;
            articleId = (String)idMapping.get(it3.getOldFileId());
            if (articleId == null) {
                return;
            }
            Object newFileId2 = articleId;
            if (it3.getNewFileId() != null && !Intrinsics.areEqual((Object)it3.getNewFileId(), (Object)newFileId2)) {
                return;
            }
            it3.setNewFileId((String)newFileId2);
        }
        this.getDriveFileMigrationRepository().saveAllAndFlush((Iterable)migrationsMapping.values());
        Iterable $this$map$iv = migrationsMapping.values();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            newFileId = (DriveFileMigration)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            string = it2.getArticleId();
            object.add(string);
        }
        Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$map22 = this.getDriveFileMigrationRepository().findByArticleIds(articleIds);
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DriveFileMigration it4 = (DriveFileMigration)element$iv$iv;
            boolean bl = false;
            if (!(it4.getNewFileId() != null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$associate = false;
        int capacity$iv222 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        destination$iv$iv3 = $this$associate$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv222);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv4;
            it = (DriveFileMigration)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getNewFileId();
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (string2 == null) {
                boolean bl6 = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            it = TuplesKt.to((Object)it.getOldFileId(), (Object)string2);
            bl2 = false;
            bl.put(it.getFirst(), it.getSecond());
        }
        Map migrationsForArticles = destination$iv$iv4;
        $this$associate$iv = this.getArticleVersionRepository().findByArticleIds(articleIds);
        boolean $i$f$flatMap = false;
        void capacity$iv222 = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void $i$f$associateTo22 = $this$flatMapTo$iv$iv;
        boolean element$iv$iv = false;
        for (Map.Entry element$iv$iv2 : $i$f$associateTo22.entrySet()) {
            it = element$iv$iv2;
            boolean bl = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ArticleVersion articleVersion;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv3 = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ArticleVersion it5 = (ArticleVersion)element$iv$iv3;
            boolean bl7 = false;
            String newContent = ProseMirrorContentParserKt.switchDriveIds((String)it5.getContent(), (Map)migrationsForArticles);
            if (Intrinsics.areEqual((Object)newContent, (Object)it5.getContent())) {
                articleVersion = null;
            } else {
                it5.setContent(newContent);
                articleVersion = it5;
            }
            if (articleVersion == null) continue;
            ArticleVersion articleVersion2 = articleVersion;
            boolean bl8 = false;
            boolean bl9 = false;
            ArticleVersion it$iv$iv = articleVersion2;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            ArticleVersion it6 = (ArticleVersion)element$iv3;
            boolean bl = false;
            ArticleVersionId articleVersionId = it6.getId();
            boolean bl11 = false;
            boolean bl12 = false;
            bl12 = false;
            boolean bl13 = false;
            if (articleVersionId == null) {
                boolean bl14 = false;
                String string4 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            this.getArticleVersionRepository().updateContentAfterMigration(articleVersionId, it6.getContent());
        }
        this.getArticleVersionRepository().flush();
    }

    private static final DriveFileMigration updateDriveMediaIds$lambda-7$lambda-6(String $oldFileId, String $newFileId, ArticleId $articleId, String it) {
        Intrinsics.checkNotNullParameter((Object)$oldFileId, (String)"$oldFileId");
        Intrinsics.checkNotNullParameter((Object)$newFileId, (String)"$newFileId");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DriveFileMigration($oldFileId, $newFileId, $articleId);
    }
}

