/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionRepository;
import de.justsoftware.wikiservice.persistence.model.Deletion;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/business/DeletionService;", "", "deletionRepository", "Lde/justsoftware/wikiservice/persistence/DeletionRepository;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "(Lde/justsoftware/wikiservice/persistence/DeletionRepository;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/WikiService;)V", "create", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletionItemId", "Lde/justsoftware/wikiservice/model/ItemId;", "deletedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "deletedAt", "Ljava/time/Instant;", "deleteWikisInTenant", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "createdBefore", "removeOldDeletions", "maxAgeInSeconds", "", "wiki-service"})
public class DeletionService {
    @NotNull
    private final DeletionRepository deletionRepository;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final WikiService wikiService;

    @Autowired
    public DeletionService(@NotNull DeletionRepository deletionRepository, @NotNull ArticleService articleService, @NotNull ChapterService chapterService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)deletionRepository, (String)"deletionRepository");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.deletionRepository = deletionRepository;
        this.articleService = articleService;
        this.chapterService = chapterService;
        this.wikiService = wikiService;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeOldDeletions(long maxAgeInSeconds) {
        void $this$mapTo$iv$iv;
        Instant deletedBefore = Instant.now().minusSeconds(maxAgeInSeconds);
        Intrinsics.checkNotNullExpressionValue((Object)deletedBefore, (String)"deletedBefore");
        Set cleanableDeletions = this.deletionRepository.findAllByDeletedAtBefore(deletedBefore);
        Iterable $this$map$iv = cleanableDeletions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Deletion deletion = (Deletion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DeletionId deletionId = it.getId();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (deletionId == null) {
                boolean bl5 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            DeletionId deletionId2 = deletionId;
            collection.add(deletionId2);
        }
        Set deletionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.articleService.removeDeletedArticles(deletionIds);
        this.chapterService.removeDeletedChapters(deletionIds);
        this.wikiService.removeDeletedWikis(cleanableDeletions);
        this.deletionRepository.deleteAll((Iterable)cleanableDeletions);
    }

    @NotNull
    public DeletionId create(@NotNull ItemId deletionItemId, @NotNull ProfileId deletedBy, @NotNull Instant deletedAt) {
        Intrinsics.checkNotNullParameter((Object)deletionItemId, (String)"deletionItemId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Intrinsics.checkNotNullParameter((Object)deletedAt, (String)"deletedAt");
        DeletionId deletionId = ((Deletion)this.deletionRepository.saveAndFlush((Object)new Deletion(deletionItemId, deletedAt, deletedBy))).getId();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (deletionId == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return deletionId;
    }

    public static /* synthetic */ DeletionId create$default(DeletionService deletionService, ItemId itemId, ProfileId profileId, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            instant = instant2;
        }
        return deletionService.create(itemId, profileId, instant);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteWikisInTenant(@NotNull TenantId tenantId, @NotNull Instant createdBefore) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)createdBefore, (String)"createdBefore");
        ProfileId deletedBy = new ProfileId(-1L);
        Instant deletedAt = Instant.now();
        Iterable iterable = this.wikiService.findWikisByTenant(tenantId);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Wiki it = (Wiki)element$iv$iv;
            boolean bl = false;
            Instant instant = it.getCreatedAt();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (instant == null) {
                boolean bl5 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (!instant.isBefore(createdBefore)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WikiId wikiId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Wiki it = (Wiki)element$iv$iv;
            boolean bl6 = false;
            if (it.getId() == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            WikiId it$iv$iv = wikiId;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            WikiId it = (WikiId)element$iv;
            boolean bl = false;
            ItemId itemId = (ItemId)it;
            Intrinsics.checkNotNullExpressionValue((Object)deletedAt, (String)"deletedAt");
            DeletionId deletionId = this.create(itemId, deletedBy, deletedAt);
            this.wikiService.delete(it, deletionId);
        }
    }
}

