/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.CircularyAncestryException;
import de.justsoftware.wikiservice.business.exceptions.ParentNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.business.model.Ancestor;
import de.justsoftware.wikiservice.business.model.AncestorDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.ChapterNestingException;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001d\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010(\u001a\u00020\u001dH\u0016J(\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0&2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010+\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0017H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\"\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0002J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J\"\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J \u0010=\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J&\u0010=\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J8\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\b\u0002\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00150BH\u0002J\u000e\u0010C\u001a\u0004\u0018\u00010\u001d*\u000202H\u0002J*\u0010D\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0&0E*\b\u0012\u0004\u0012\u00020\u001d0&H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lde/justsoftware/wikiservice/business/AncestorService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "maxChapterDepth", "", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/WikiRepository;ILde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "checkCircularAncestry", "", "parentAncestors", "", "Lde/justsoftware/wikiservice/business/model/AncestorDto;", "movedElement", "Lde/justsoftware/wikiservice/model/AbstractId;", "checkMaxNestingDepth", "parentChaptersNestingDepth", "childrenChaptersNestingDepth", "checkMaxNestingDepthOfNewChapter", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "checkValidMove", "toParent", "checkValidMove$wiki_service", "getAncestorWikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "getAncestorWikiIds", "", "parentIds", "", "getAncestors", "firstAncestor", "getDescendantChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "wikiId", "getDescendants", "getMaxChildrenChaptersNestingDepth", "childrenId", "getNextPositionForParent", "getPreviousPositionForParent", "loadAncestors", "Lde/justsoftware/wikiservice/business/model/Ancestor;", "firstAncestors", "moveArticle", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "updater", "Lde/justsoftware/wikiservice/model/ProfileId;", "moveChapter", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "updateEditedStatusForAncestors", "updatedAt", "Ljava/time/Instant;", "updatedBy", "ancestors", "", "getParentId", "groupByType", "Lkotlin/Pair;", "wiki-service"})
public class AncestorService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final WikiRepository wikiRepository;
    private final int maxChapterDepth;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public AncestorService(@NotNull PermissionService permissionService, @NotNull ChapterRepository chapterRepository, @NotNull ArticleRepository articleRepository, @NotNull WikiRepository wikiRepository, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.permissionService = permissionService;
        this.chapterRepository = chapterRepository;
        this.articleRepository = articleRepository;
        this.wikiRepository = wikiRepository;
        this.maxChapterDepth = maxChapterDepth;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public WikiId getAncestorWikiId(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = (WikiId)this.getAncestorWikiIds(SetsKt.setOf((Object)parentId)).get(parentId);
        if (wikiId == null) {
            throw new WikiNotFoundException((WikiId)parentId);
        }
        return wikiId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, WikiId> getAncestorWikiIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Pair pair;
        Collection collection;
        Iterator $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Pair pair2 = this.groupByType(parentIds);
        Set chapterIds = (Set)pair2.component1();
        Set wikiIds = (Set)pair2.component2();
        Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object item$iv$iv = iterator.next();
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ChapterId chapterId = it2.getId();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (chapterId == null) {
                boolean bl5 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ChapterId id = chapterId;
            pair = TuplesKt.to((Object)id, (Object)it2.getWikiId());
            collection.add(pair);
        }
        Map chapterAncestor = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = chapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv2;
            boolean bl = false;
            boolean bl6 = chapterAncestor.containsKey(it);
            boolean it2 = false;
            if (!_Assertions.ENABLED || bl6) continue;
            boolean bl7 = false;
            throw new ChapterNotFoundException(it);
        }
        Iterable $this$map$iv2 = wikiIds;
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void wikiId;
            WikiId bl7 = (WikiId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            pair = TuplesKt.to((Object)wikiId, (Object)wikiId);
            collection.add(pair);
        }
        Map wikiAncestor = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        return MapsKt.plus((Map)wikiAncestor, (Map)chapterAncestor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<AbstractId> getDescendants(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        ChapterId chapterId;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$map$iv = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            chapterId = it.getId();
            collection.add(chapterId);
        }
        Set chapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.articleRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article bl = (Article)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            chapterId = it.getId();
            collection.add(chapterId);
        }
        Set articles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return SetsKt.plus((Set)chapters, (Iterable)articles);
    }

    @NotNull
    public List<AncestorDto> getAncestors(@NotNull ParentId firstAncestor) {
        Intrinsics.checkNotNullParameter((Object)firstAncestor, (String)"firstAncestor");
        return this.getAncestors(SetsKt.setOf((Object)firstAncestor)).getOrDefault(firstAncestor, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<AncestorDto>> getAncestors(@NotNull Set<? extends ParentId> firstAncestor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(firstAncestor, (String)"firstAncestor");
        Map loadedAncestors = this.loadAncestors(firstAncestor);
        Iterable $this$map$iv = firstAncestor;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)AncestorService.getAncestors$default((AncestorService)this, (Map)loadedAncestors, (ParentId)it, null, (int)2, null));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final List<AncestorDto> getAncestors(Map<ParentId, ? extends Ancestor> $this$getAncestors, ParentId parentId, List<AncestorDto> ancestors) {
        ParentId ancestorId = parentId;
        while (ancestorId != null) {
            Ancestor ancestor = $this$getAncestors.get(ancestorId);
            if (ancestor == null) {
                throw new ParentNotFoundException(ancestorId);
            }
            Ancestor ancestor2 = ancestor;
            ancestors.add(0, new AncestorDto(ancestor2.getId(), ancestor2.getTitle()));
            ancestorId = this.getParentId(ancestor2);
        }
        return ancestors;
    }

    static /* synthetic */ List getAncestors$default(AncestorService ancestorService, Map map, ParentId parentId, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAncestors");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        return ancestorService.getAncestors(map, parentId, list);
    }

    private final ParentId getParentId(Ancestor $this$getParentId) {
        return $this$getParentId instanceof ChapterDto ? ((ChapterDto)$this$getParentId).getParentId() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ParentId, Ancestor> loadAncestors(Set<? extends ParentId> firstAncestors) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Object object;
        Object object2;
        Map map2;
        Set wikiIds;
        Object object3;
        if (firstAncestors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        boolean bl = false;
        Map loadedAncestors = new LinkedHashMap();
        boolean bl2 = false;
        Set parentWikiIds = new LinkedHashSet();
        Set nextParentIds = firstAncestors;
        while (true) {
            Set set;
            object3 = nextParentIds;
            boolean bl3 = false;
            if (!(!object3.isEmpty())) break;
            object3 = this.groupByType(nextParentIds);
            Set chapterIds = (Set)object3.component1();
            wikiIds = (Set)object3.component2();
            parentWikiIds.addAll(wikiIds);
            if (chapterIds.isEmpty()) {
                set = SetsKt.emptySet();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                ParentId it;
                Map $this$mapTo$iv$iv32;
                Object $this$map$iv;
                Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv32.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    map2 = (Chapter)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl4 = false;
                    object = it.getId();
                    if (object == null) {
                        throw new ChapterNotFoundException(null, 1, null);
                    }
                    Object id = object;
                    map = TuplesKt.to(id, (Object)ChapterDto.Companion.toChapterDto((Chapter)it));
                    object2.add(map);
                }
                $this$map$iv = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                $i$f$map = false;
                boolean $this$mapTo$iv$iv32 = false;
                Map it2 = $this$map$iv;
                boolean bl5 = false;
                loadedAncestors.putAll(it2);
                $i$f$map = false;
                $this$mapTo$iv$iv32 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv32;
                boolean item$iv$iv = false;
                it = iterator.entrySet().iterator();
                while (it.hasNext()) {
                    void it3;
                    Map.Entry item$iv$iv2 = it.next();
                    object = item$iv$iv2;
                    object2 = destination$iv$iv;
                    boolean bl6 = false;
                    map = ((ChapterDto)it3.getValue()).getParentId();
                    object2.add(map);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv32 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ParentId)element$iv$iv;
                    boolean bl7 = false;
                    if (!(!loadedAncestors.containsKey(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            nextParentIds = set;
        }
        object3 = this.wikiRepository.findByIds(parentWikiIds);
        object2 = loadedAncestors;
        boolean $i$f$mapValues = false;
        wikiIds = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$wiki;
            void it$iv$iv;
            Map.Entry element$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl8 = false;
            object = it$iv$iv.getKey();
            Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
            Object k = object;
            map = map2;
            boolean bl9 = false;
            void var20_36 = $dstr$_u24__u24$wiki;
            boolean bl10 = false;
            Wiki wiki = (Wiki)var20_36.getValue();
            WikiDto wikiDto = WikiDto.Companion.toDto(wiki);
            map.put(k, wikiDto);
        }
        map = destination$iv$iv;
        object2.putAll(map);
        return loadedAncestors;
    }

    private final Pair<Set<ChapterId>, Set<WikiId>> groupByType(Set<? extends ParentId> $this$groupByType) {
        boolean bl = false;
        Set chapterIds = new LinkedHashSet();
        boolean bl2 = false;
        Set wikiIds = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$groupByType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParentId it = (ParentId)element$iv;
            boolean bl3 = false;
            ParentId parentId = it;
            if (parentId instanceof WikiId) {
                wikiIds.add(it);
                continue;
            }
            if (parentId instanceof ChapterId) {
                chapterIds.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported parent type: " + it.type());
        }
        return new Pair((Object)chapterIds, (Object)wikiIds);
    }

    @Transactional
    public void updateEditedStatusForAncestors(@NotNull ParentId parentId, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        this.updateEditedStatusForAncestors(SetsKt.setOf((Object)parentId), updatedAt, updatedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateEditedStatusForAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Collection<ParentId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Iterable iterable = CollectionsKt.flatten((Iterable)this.getAncestors(parentIds).values());
        AncestorService ancestorService = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AncestorDto ancestorDto = (AncestorDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ParentId parentId = it.getId();
            collection.add(parentId);
        }
        collection = (List)destination$iv$iv;
        Pair pair = ancestorService.groupByType(CollectionsKt.toSet((Iterable)collection));
        Set parentChaptersIds = (Set)pair.component1();
        Set parentWikiIds = (Set)pair.component2();
        WikiId parentWikiId = (WikiId)CollectionsKt.first((Iterable)parentWikiIds);
        this.chapterRepository.setUpdatedStatus(parentChaptersIds, updatedBy, updatedAt);
        this.wikiRepository.setUpdatedStatus(parentWikiId, updatedBy, updatedAt);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean moveChapter(@NotNull ChapterId chapterId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chapter chapter = (Chapter)this.chapterRepository.getOne((Object)chapterId);
        Intrinsics.checkNotNullExpressionValue((Object)chapter, (String)"chapter");
        ParentId oldParentId = Chapter.Companion.getParent(chapter);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)chapter.getParentId()) && toParent.type() == chapter.getParentType()) {
            return false;
        }
        ChapterId chapterId2 = chapter.getId();
        if (chapterId2 == null) {
            throw new ChapterNotFoundException(chapterId);
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)chapterId2);
        WikiId toWikiId = this.getAncestorWikiId(toParent);
        boolean bl = false;
        Set chaptersToUpdate = new LinkedHashSet();
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)chapter.getWikiId())) {
            void $this$mapTo$iv$iv;
            boolean bl2;
            void $this$mapTo$iv$iv2;
            ChapterId chapterId3;
            boolean bl3;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = this.getDescendantChapters(chapter.getWikiId(), (ParentId)chapterId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void childChapter;
                Chapter chapter2 = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                void var18_37 = childChapter;
                boolean bl5 = false;
                bl3 = false;
                void $this$moveChapter_u24lambda_u2d15_u24lambda_u2d14 = var18_37;
                boolean bl6 = false;
                $this$moveChapter_u24lambda_u2d15_u24lambda_u2d14.setWikiId(toWikiId);
                chapterId3 = var18_37;
                collection.add(chapterId3);
            }
            List updatedChapters = (List)destination$iv$iv;
            chaptersToUpdate.addAll(updatedChapters);
            Iterable $this$map$iv2 = updatedChapters;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Chapter bl4 = (Chapter)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl7 = false;
                ChapterId chapterId4 = it.getId();
                bl3 = false;
                boolean bl8 = false;
                bl8 = false;
                bl2 = false;
                if (chapterId4 == null) {
                    boolean bl9 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                chapterId3 = chapterId4;
                collection.add(chapterId3);
            }
            Set parentIds = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), (Iterable)SetsKt.setOf((Object)chapterId));
            Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)this.articleRepository.findByParentIds(parentIds).values());
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void article;
                Article bl7 = (Article)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl10 = false;
                void var20_44 = article;
                boolean bl11 = false;
                bl2 = false;
                void $this$moveChapter_u24lambda_u2d18_u24lambda_u2d17 = var20_44;
                boolean bl12 = false;
                $this$moveChapter_u24lambda_u2d18_u24lambda_u2d17.setWikiId(toWikiId);
                chapterId3 = var20_44;
                collection.add(chapterId3);
            }
            List updatedArticles = (List)destination$iv$iv3;
            $this$map$iv3 = updatedArticles;
            $i$f$map3 = false;
            if (!$this$map$iv3.isEmpty()) {
                this.articleRepository.saveAll((Iterable)updatedArticles);
                Iterable $this$forEach$iv = updatedArticles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Article it = (Article)element$iv;
                    boolean bl13 = false;
                    ArticleId articleId = it.getId();
                    if (articleId == null) {
                        throw new ArticleNotFoundException(null, 1, null);
                    }
                    this.permissionService.removePermissionsForDeletedArticle(articleId);
                    articleId = it.getId();
                    if (articleId == null) {
                        throw new ArticleNotFoundException(null, 1, null);
                    }
                    this.permissionService.addPermissionItemForNewArticle(articleId, toWikiId);
                }
                this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
            chapter.setWikiId(toWikiId);
            chapter.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
        } else {
            chapter.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        chapter.setParentId(toParent.getId());
        chapter.setParentType(toParent.type());
        chaptersToUpdate.add(chapter);
        List updatedChapters = this.chapterRepository.saveAll((Iterable)chaptersToUpdate);
        Intrinsics.checkNotNullExpressionValue((Object)updatedChapters, (String)"updatedChapters");
        Instant instant = ((Chapter)CollectionsKt.last((List)updatedChapters)).getUpdatedAt();
        boolean bl14 = false;
        boolean bl15 = false;
        bl15 = false;
        boolean bl16 = false;
        if (instant == null) {
            boolean bl17 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    @Transactional
    public boolean moveArticle(@NotNull ArticleId articleId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getOne((Object)articleId);
        Intrinsics.checkNotNullExpressionValue((Object)article, (String)"article");
        ParentId oldParentId = Article.Companion.getParent(article);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)article.getParentId()) && toParent.type() == article.getParentType()) {
            return false;
        }
        ArticleId articleId2 = article.getId();
        if (articleId2 == null) {
            throw new ArticleNotFoundException(articleId);
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)articleId2);
        articleId2 = this.getAncestorWikiId(toParent);
        boolean bl = false;
        boolean bl2 = false;
        ArticleId $this$moveArticle_u24lambda_u2d20 = articleId2;
        boolean bl3 = false;
        if (!Intrinsics.areEqual((Object)$this$moveArticle_u24lambda_u2d20, (Object)article.getWikiId())) {
            article.setWikiId((WikiId)$this$moveArticle_u24lambda_u2d20);
            article.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
            this.permissionService.removePermissionsForDeletedArticle(articleId);
            this.permissionService.addPermissionItemForNewArticle(articleId, (WikiId)toParent);
        } else {
            article.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        article.setParentId(toParent.getId());
        article.setParentType(toParent.type());
        Article updatedArticle = (Article)this.articleRepository.save((Object)article);
        Instant instant = updatedArticle.getUpdatedAt();
        boolean bl4 = false;
        boolean bl5 = false;
        bl5 = false;
        boolean bl6 = false;
        if (instant == null) {
            boolean bl7 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void checkValidMove$wiki_service(@NotNull ParentId toParent, @NotNull AbstractId movedElement) {
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)movedElement, (String)"movedElement");
        ParentId parentId = toParent;
        if (parentId instanceof ChapterId) {
            if (!this.chapterRepository.existsById((Object)toParent)) {
                throw new ChapterNotFoundException((ChapterId)toParent);
            }
            if (movedElement.type() == IdType.WIKI_CHAPTER) {
                List parentAncestors = this.getAncestors(toParent);
                int parentChaptersNestingDepth = parentAncestors.size() - 1;
                int childrenChaptersNestingDepth = this.getMaxChildrenChaptersNestingDepth(movedElement);
                this.checkMaxNestingDepth(parentChaptersNestingDepth, childrenChaptersNestingDepth);
                this.checkCircularAncestry(parentAncestors, movedElement);
            }
        } else if (parentId instanceof WikiId) {
            if (!this.wikiRepository.existsById((Object)toParent)) {
                throw new WikiNotFoundException((WikiId)toParent);
            }
        } else {
            throw new IllegalArgumentException(toParent.type() + " is not a known parent type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getMaxChildrenChaptersNestingDepth(AbstractId childrenId) {
        int n;
        AbstractId abstractId = childrenId;
        if (abstractId instanceof ParentId) {
            void var3_3;
            int depth = 0;
            Set nextParentIds = SetsKt.setOf((Object)childrenId);
            while (true) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection = nextParentIds;
                int n2 = 0;
                if (!(!collection.isEmpty())) break;
                Map children = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, (Set)nextParentIds, null, (int)2, null);
                Iterable iterable = CollectionsKt.flatten((Iterable)children.values());
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chapter chapter = (Chapter)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    ParentId parentId = (ParentId)it.getId();
                    if (parentId == null) {
                        throw new ParentNotFoundException(null, 1, null);
                    }
                    ParentId parentId2 = parentId;
                    collection2.add(parentId2);
                }
                nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                n2 = depth;
                depth = n2 + 1;
            }
            n = var3_3;
        } else {
            n = 0;
        }
        return n;
    }

    public void checkMaxNestingDepthOfNewChapter(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        int parentChaptersNestingDepth = this.getAncestors(parentId).size() - 1;
        this.checkMaxNestingDepth(parentChaptersNestingDepth, 1);
    }

    private final void checkMaxNestingDepth(int parentChaptersNestingDepth, int childrenChaptersNestingDepth) {
        if (parentChaptersNestingDepth + childrenChaptersNestingDepth > this.maxChapterDepth) {
            throw new ChapterNestingException("Maximum chapter nesting level " + this.maxChapterDepth + " reached");
        }
    }

    private final void checkCircularAncestry(List<AncestorDto> parentAncestors, AbstractId movedElement) {
        boolean hasCircularAncestry;
        block4: {
            boolean bl;
            Iterable $this$any$iv = parentAncestors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AncestorDto it = (AncestorDto)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)movedElement)) continue;
                    bl = true;
                    break block4;
                }
                bl = hasCircularAncestry = false;
            }
        }
        if (hasCircularAncestry) {
            throw new CircularyAncestryException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getNextPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Map.Entry element$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Object object = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var9_11 = $this$flatMapTo$iv$iv2;
        boolean bl2 = false;
        Iterator iterator = var9_11.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = iterator.next();
            boolean bl3 = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer n;
            Map.Entry element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl5 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl6 = false;
            bl = false;
            Integer it$iv$iv = n;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMax = n == null ? -1 : n;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        void $i$f$forEach22 = $this$flatMapTo$iv$iv;
        boolean bl8 = false;
        Iterator iterator2 = $i$f$forEach22.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl9 = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer n2;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl10 = false;
            Article it = (Article)element$iv$iv3;
            boolean bl11 = false;
            if (it.getRelativePosition() == null) continue;
            bl = false;
            boolean bl12 = false;
            Integer it$iv$iv = n2;
            boolean bl13 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        object = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMax = object == null ? -1 : (Integer)object;
        boolean bl14 = false;
        return Math.max(chapterPositionMax, articlePositionMax) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getPreviousPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Map.Entry element$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Object object = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var9_11 = $this$flatMapTo$iv$iv2;
        boolean bl2 = false;
        Iterator iterator = var9_11.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = iterator.next();
            boolean bl3 = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer n;
            Map.Entry element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl5 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl6 = false;
            bl = false;
            Integer it$iv$iv = n;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMin = n == null ? 0 : n;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        void $i$f$forEach22 = $this$flatMapTo$iv$iv;
        boolean bl8 = false;
        Iterator iterator2 = $i$f$forEach22.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl9 = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer n2;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl10 = false;
            Article it = (Article)element$iv$iv3;
            boolean bl11 = false;
            if (it.getRelativePosition() == null) continue;
            bl = false;
            boolean bl12 = false;
            Integer it$iv$iv = n2;
            boolean bl13 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        object = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMin = object == null ? 0 : (Integer)object;
        boolean bl14 = false;
        return Math.min(chapterPositionMin, articlePositionMin) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Chapter> getDescendantChapters(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean bl = false;
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (true) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Collection collection = nextParentIds;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) break;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Chapter it = (Chapter)element$iv$iv;
                boolean bl3 = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UUID uUID;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                Chapter it = (Chapter)element$iv$iv;
                boolean bl5 = false;
                ChapterId chapterId = it.getId();
                if ((chapterId == null ? null : chapterId.getId()) == null) continue;
                uUID = uUID;
                boolean bl6 = false;
                boolean bl7 = false;
                UUID it$iv$iv = uUID;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            nextParentIds = CollectionsKt.toSet((Iterable)list);
        }
        return result;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(AncestorService $this) {
        return $this.applicationEventPublisher;
    }
}

