/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.business.model.TableOfContentsDto;
import de.justsoftware.wikiservice.graphql.generated.UpdateTableOfContentsInput;
import de.justsoftware.wikiservice.model.ParentId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;", "", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "(Lde/justsoftware/wikiservice/business/TableOfContentsService;Lde/justsoftware/wikiservice/business/AncestorService;)V", "read", "Lde/justsoftware/wikiservice/business/model/TableOfContentsDto;", "id", "Lde/justsoftware/wikiservice/model/ParentId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "update", "", "input", "Lde/justsoftware/wikiservice/graphql/generated/UpdateTableOfContentsInput;", "wiki-service"})
public class TableOfContentsApplicationService {
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    @NotNull
    private final AncestorService ancestorService;

    @Autowired
    public TableOfContentsApplicationService(@NotNull TableOfContentsService tableOfContentsService, @NotNull AncestorService ancestorService) {
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        this.tableOfContentsService = tableOfContentsService;
        this.ancestorService = ancestorService;
    }

    @NotNull
    public TableOfContentsDto read(@NotNull ParentId id, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(this.ancestorService.getAncestorWikiId(id));
        return this.tableOfContentsService.read(id);
    }

    public boolean update(@NotNull UpdateTableOfContentsInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(input.getWikiId());
        return this.tableOfContentsService.update(input.getWikiId(), input.getItems(), authContext.getUser());
    }
}

