/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.NotAWikiException;
import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.WikiId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "(Lde/justsoftware/wikiservice/business/SubscriptionService;)V", "setSubscription", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class SubscriptionApplicationService {
    @NotNull
    private final SubscriptionService subscriptionService;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        this.subscriptionService = subscriptionService;
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (itemId.type() != IdType.WIKI_WIKI) {
            throw new NotAWikiException();
        }
        authContext.checkReadWiki((WikiId)itemId);
        return this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed);
    }
}

