/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.DuplicateGranteeIdException;
import de.justsoftware.wikiservice.business.model.PermissionDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.generated.SetPermissionItemInput;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "getPermissionsForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "Lde/justsoftware/wikiservice/business/model/PermissionDto;", "wikiIds", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "republishPermissions", "", "setPermissions", "wikiId", "newPermissions", "Lde/justsoftware/wikiservice/graphql/generated/SetPermissionItemInput;", "setPermissionsForWikiCreation", "permissions", "setPermissionsForWikiUpdate", "wiki-service"})
public class PermissionApplicationService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public PermissionApplicationService(@NotNull PermissionService permissionService, @NotNull WikiService wikiService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.permissionService = permissionService;
        this.wikiService = wikiService;
        this.authorizationService = authorizationService;
    }

    public void republishPermissions() {
        this.permissionService.republishPermissions();
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiUpdate(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        return this.setPermissions(wikiId, permissions, authContext);
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiCreation(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        return this.setPermissions(wikiId, permissions, authContext);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionDto> setPermissions(WikiId wikiId, List<SetPermissionItemInput> newPermissions, AuthContext authContext) {
        void $this$groupByTo$iv$iv;
        Iterable<Object> element$iv2;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Collection $this$mapNotNullTo$iv$iv;
        boolean bl;
        void $this$mapNotNullTo$iv$iv2;
        boolean bl22;
        void $this$mapNotNullTo$iv$iv3;
        boolean bl3;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv4;
        Iterable $this$mapNotNull$iv = newPermissions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ProfileId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv4;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId profileId;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl4 = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl5 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl6 = false;
            bl3 = false;
            ProfileId it$iv$iv = profileId;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = newPermissions;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        Iterable $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach3 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId userGroupId;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl8 = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl9 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            bl3 = false;
            boolean it$iv$iv = false;
            UserGroupId it$iv$iv2 = userGroupId;
            bl22 = false;
            destination$iv$iv2.add(it$iv$iv2);
        }
        Set newUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (newPermissions.size() != newProfiles.size() + newUserGroups.size()) {
            throw new DuplicateGranteeIdException();
        }
        WikiDto wikiToUpdate = this.wikiService.read(wikiId);
        List currentPermissions = this.permissionService.getPermissionsByWikiId(wikiId);
        Iterable $this$mapNotNull$iv3 = currentPermissions;
        boolean $i$f$mapNotNull3 = false;
        $this$forEach$iv$iv$iv2 = $this$mapNotNull$iv3;
        Iterable<ProfileId> destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach4 = false;
        Iterator bl8 = $this$forEach$iv$iv$iv3.iterator();
        while (bl8.hasNext()) {
            ProfileId it$iv$iv2;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = bl8.next();
            boolean bl10 = false;
            PermissionDto it = (PermissionDto)element$iv$iv;
            boolean bl11 = false;
            if (it.getGrantee().getId().toProfileId() == null) continue;
            bl22 = false;
            bl = false;
            ProfileId it$iv$iv = it$iv$iv2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set currentProfileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Iterable $this$mapNotNull$iv4 = currentPermissions;
        boolean $i$f$mapNotNull4 = false;
        destination$iv$iv3 = $this$mapNotNull$iv4;
        Collection destination$iv$iv222 = new ArrayList();
        boolean $i$f$mapNotNullTo4 = false;
        void $this$forEach$iv$iv$iv4 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach5 = false;
        Iterator element$iv$iv$iv4 = $this$forEach$iv$iv$iv4.iterator();
        while (element$iv$iv$iv4.hasNext()) {
            UserGroupId bl22;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = element$iv$iv$iv4.next();
            boolean bl12 = false;
            PermissionDto it = (PermissionDto)element$iv$iv;
            boolean bl13 = false;
            if (it.getGrantee().getId().toUserGroupId() == null) continue;
            bl = false;
            boolean it$iv$iv = false;
            UserGroupId it$iv$iv3 = bl22;
            boolean $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv2 = false;
            destination$iv$iv222.add(it$iv$iv3);
        }
        Set currentUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv222));
        Set addedProfiles = SetsKt.minus((Set)newProfiles, (Iterable)currentProfileIds);
        Set addedUserGroups = SetsKt.minus((Set)newUserGroups, (Iterable)currentUserGroups);
        $this$mapNotNullTo$iv$iv = addedProfiles;
        boolean destination$iv$iv222 = false;
        if (!$this$mapNotNullTo$iv$iv.isEmpty()) {
            this.authorizationService.checkReadProfiles(addedProfiles, authContext.getUser());
            $this$forEach$iv = addedProfiles;
            $i$f$forEach = false;
            for (Iterable<Object> element$iv2 : $this$forEach$iv) {
                ProfileId it = (ProfileId)element$iv2;
                boolean bl14 = false;
                this.authorizationService.checkIfProfileMayReadTenant(wikiToUpdate.getTenantId(), it);
            }
        }
        $this$forEach$iv = addedUserGroups;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            this.authorizationService.checkReadUserGroups(addedUserGroups, authContext.getUser());
        }
        Iterable $this$groupBy$iv = newPermissions;
        boolean $i$f$groupBy = false;
        element$iv2 = $this$groupBy$iv;
        Map destination$iv$iv4 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            SetPermissionItemInput it2 = (SetPermissionItemInput)element$iv$iv;
            boolean $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = false;
            PermissionType key$iv$iv = PermissionType.valueOf((String)it2.getType().name());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl15 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            SetPermissionItemInput $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = (SetPermissionItemInput)element$iv$iv;
            List list = list$iv$iv;
            boolean bl16 = false;
            GranteeId granteeId = it.getGranteeId();
            list.add(granteeId);
        }
        Map permissionMap = destination$iv$iv4;
        return this.permissionService.setPermissions(wikiId, permissionMap);
    }

    @NotNull
    public Map<WikiId, List<PermissionDto>> getPermissionsForWikis(@NotNull List<? extends WikiId> wikiIds, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set wikiSet = CollectionsKt.toSet((Iterable)wikiIds);
        authContext.checkManageWikis(wikiSet);
        return this.permissionService.getPermissionsByWikiIds(wikiSet);
    }
}

