/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.graphql.generated.CreateChapterInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateChapterInput;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "(Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;)V", "countChaptersForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "chapterInput", "Lde/justsoftware/wikiservice/graphql/generated/CreateChapterInput;", "delete", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "getAllChildChapters", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "read", "update", "input", "Lde/justsoftware/wikiservice/graphql/generated/UpdateChapterInput;", "wiki-service"})
public class ChapterApplicationService {
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;

    @Autowired
    public ChapterApplicationService(@NotNull ChapterService chapterService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.chapterService = chapterService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
    }

    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto chapterDto = this.chapterService.read(chapterId);
        boolean bl = false;
        boolean bl2 = false;
        ChapterDto it = chapterDto;
        boolean bl3 = false;
        authContext.checkReadWiki(it.getWikiId());
        return chapterDto;
    }

    @Transactional
    @NotNull
    public ChapterDto update(@NotNull ChapterId chapterId, @NotNull UpdateChapterInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId((ParentId)chapterId);
        if (input.getParentId() != null) {
            WikiId toWikiId = this.ancestorService.getAncestorWikiId(input.getParentId());
            authContext.checkMoveWikiContent(wikiId, toWikiId);
        } else {
            authContext.checkWriteWiki(wikiId);
        }
        boolean chapterWasMoved = this.ancestorService.moveChapter(chapterId, input.getParentId(), authContext.getUser());
        return this.chapterService.update(chapterId, input.getTitle(), authContext.getUser(), chapterWasMoved);
    }

    @Transactional
    @NotNull
    public ChapterDto delete(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto chapterDto = this.chapterService.read(chapterId);
        boolean bl = false;
        boolean bl2 = false;
        ChapterDto chapterDto2 = chapterDto;
        boolean bl3 = false;
        authContext.checkWriteWiki(chapterDto2.getWikiId());
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)chapterId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.chapterService.delete(chapterId, deletionId, authContext.getUser());
        return chapterDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ChapterDto>> getAllChildChapters(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List chapters;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map map = this.chapterService.readByParentIds(CollectionsKt.toSet((Iterable)parentIds));
        boolean bl = false;
        boolean bl2 = false;
        Map parentIdsToChildChapters = map;
        boolean bl3 = false;
        Iterable iterable = parentIdsToChildChapters.values();
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            chapters = (List)element$iv$iv;
            boolean bl4 = false;
            Collection collection = chapters;
            boolean bl5 = false;
            boolean bl6 = !collection.isEmpty();
            if (!bl6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            chapters = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            WikiId wikiId = ((ChapterDto)CollectionsKt.first((List)chapters)).getWikiId();
            collection.add(wikiId);
        }
        Set parentWikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadWikis(parentWikiIds);
        return map;
    }

    @NotNull
    public Map<WikiId, Integer> countChaptersForWikis(@NotNull List<? extends WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.chapterService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    @NotNull
    public ChapterDto create(@NotNull CreateChapterInput chapterInput, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterInput, (String)"chapterInput");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = chapterInput.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        this.ancestorService.checkMaxNestingDepthOfNewChapter(parentId);
        return this.chapterService.create(wikiId, parentId, chapterInput.getTitle(), authContext.getUser(), position);
    }
}

