/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleVersionDto;
import de.justsoftware.wikiservice.graphql.generated.CreateArticleInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateArticleInput;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u000e0\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0016J0\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(*\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\nH\u0002J3\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H*0,H\u0002\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;)V", "countArticlesForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "input", "Lde/justsoftware/wikiservice/graphql/generated/CreateArticleInput;", "delete", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "deleteEditingToken", "", "read", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readArticleVersions", "Lde/justsoftware/wikiservice/business/model/ArticleVersionDto;", "articleIds", "readByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "update", "Lde/justsoftware/wikiservice/graphql/generated/UpdateArticleInput;", "updateEditingToken", "toWikiIds", "", "withWriteCheck", "T", "block", "Lkotlin/Function1;", "(Lde/justsoftware/wikiservice/authorization/AuthContext;Lde/justsoftware/wikiservice/model/ArticleId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wiki-service"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;

    @Autowired
    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
    }

    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto articleDto = this.articleService.read(articleId);
        boolean bl = false;
        boolean bl2 = false;
        ArticleDto it = articleDto;
        boolean bl3 = false;
        authContext.checkReadWiki(it.getWikiId());
        return articleDto;
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto articleDto = this.articleService.readArticleByVersionId(versionId);
        boolean bl = false;
        boolean bl2 = false;
        ArticleDto it = articleDto;
        boolean bl3 = false;
        authContext.checkReadWiki(it.getWikiId());
        return articleDto;
    }

    @NotNull
    public Map<ArticleId, List<ArticleVersionDto>> readArticleVersions(@NotNull List<? extends ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        return this.articleService.readVersions(CollectionsKt.toSet((Iterable)articleIds));
    }

    @NotNull
    public Map<ParentId, List<ArticleDto>> readByParentIds(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (parentIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Map map2 = this.articleService.readByParentIds(CollectionsKt.toSet((Iterable)parentIds));
            boolean bl = false;
            boolean bl2 = false;
            Map it = map2;
            boolean bl3 = false;
            authContext.checkReadWikis(this.toWikiIds(it));
            map = map2;
        }
        return map;
    }

    @NotNull
    public Map<WikiId, Integer> countArticlesForWikis(@NotNull List<? extends WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.articleService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<WikiId> toWikiIds(Map<ParentId, ? extends List<ArticleDto>> $this$toWikiIds) {
        void $this$mapTo$iv$iv;
        Object object;
        Map<ParentId, ? extends List<ArticleDto>> $this$filterValues$iv = $this$toWikiIds;
        boolean $i$f$filterValues = false;
        Map<ParentId, List<ArticleDto>> result$iv = new LinkedHashMap();
        Map<ParentId, ? extends List<ArticleDto>> map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<ParentId, ? extends List<ArticleDto>> entry$iv : map.entrySet()) {
            List<ArticleDto> it = entry$iv.getValue();
            boolean bl2 = false;
            object = it;
            boolean bl3 = false;
            boolean bl4 = !object.isEmpty();
            if (!bl4) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<ParentId, ? extends List<ArticleDto>>> iterator = $this$mapTo$iv$iv;
        boolean bl5 = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void it;
            object = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            WikiId wikiId = ((ArticleDto)CollectionsKt.first((List)((List)it.getValue()))).getWikiId();
            collection.add(wikiId);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public ArticleDto create(@NotNull CreateArticleInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = input.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        return this.articleService.create(parentId, wikiId, input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), position, input.getContactPerson());
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @NotNull UpdateArticleInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto article = this.articleService.read(articleId);
        if (input.getParentId() != null) {
            WikiId toWikiId = this.ancestorService.getAncestorWikiId(input.getParentId());
            authContext.checkMoveWikiContent(article.getWikiId(), toWikiId);
        } else {
            authContext.checkWriteWiki(article.getWikiId());
        }
        boolean articleWasMoved = this.ancestorService.moveArticle(articleId, input.getParentId(), authContext.getUser());
        return this.articleService.update(article.getId(), input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), input.getContactPerson(), articleWasMoved);
    }

    @Transactional
    @NotNull
    public ArticleDto delete(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (ArticleDto)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private final <T> T withWriteCheck(AuthContext $this$withWriteCheck, ArticleId articleId, Function1<? super ArticleDto, ? extends T> block) {
        ArticleDto article = this.articleService.read(articleId);
        $this$withWriteCheck.checkWriteWiki(article.getWikiId());
        return (T)block.invoke((Object)article);
    }

    public static final /* synthetic */ DeletionService access$getDeletionService$p(ArticleApplicationService $this) {
        return $this.deletionService;
    }

    public static final /* synthetic */ ArticleService access$getArticleService$p(ArticleApplicationService $this) {
        return $this.articleService;
    }
}

