/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.model.AncestorDto;
import de.justsoftware.wikiservice.model.ParentId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/application/AncestorApplicationService;", "", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "(Lde/justsoftware/wikiservice/business/AncestorService;)V", "getAncestors", "", "Lde/justsoftware/wikiservice/model/ParentId;", "", "Lde/justsoftware/wikiservice/business/model/AncestorDto;", "parentIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class AncestorApplicationService {
    @NotNull
    private final AncestorService ancestorService;

    @Autowired
    public AncestorApplicationService(@NotNull AncestorService ancestorService) {
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        this.ancestorService = ancestorService;
    }

    @NotNull
    public Map<ParentId, List<AncestorDto>> getAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set wikiIds = CollectionsKt.toSet((Iterable)this.ancestorService.getAncestorWikiIds(parentIds).values());
        authContext.checkReadWikis(wikiIds);
        return this.ancestorService.getAncestors(parentIds);
    }
}

