/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.saml.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import java.util.Date;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;

public class ExpiringUsernameAuthenticationTokenSerializer
extends JsonSerializer<ExpiringUsernameAuthenticationToken> {
    public void serialize(ExpiringUsernameAuthenticationToken token, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Date tokenExpiration;
        JsonSerdesUtil.writeBoolean(gen, "authenticated", token.isAuthenticated());
        JsonSerdesUtil.writeStringArray(gen, "authorities", token.getAuthorities(), a -> a.getAuthority());
        JsonSerdesUtil.writeObject(gen, "principal", token.getPrincipal());
        JsonSerdesUtil.writeSerializable(gen, "credentials", token.getCredentials());
        Object details = token.getDetails();
        if (token.getPrincipal() != details) {
            JsonSerdesUtil.writeObject(gen, "details", details);
        }
        if ((tokenExpiration = token.getTokenExpiration()) != null) {
            JsonSerdesUtil.writeLong(gen, "tokenExpiration", tokenExpiration.getTime());
        }
    }

    public void serializeWithType(ExpiringUsernameAuthenticationToken token, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)token, gen);
        this.serialize(token, gen, provider);
        typeSer.writeTypeSuffixForObject((Object)token, gen);
    }
}

