/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.saml.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;

@ParametersAreNonnullByDefault
public class ExpiringUsernameAuthenticationTokenDeserializer
extends JsonDeserializer<ExpiringUsernameAuthenticationToken> {
    public ExpiringUsernameAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode jsonNode = JsonSerdesUtil.readTree(jp);
        ExpiringUsernameAuthenticationToken token = JsonSerdesUtil.readBooleanNonnull(jsonNode, "authenticated") ? new ExpiringUsernameAuthenticationToken(this.getDate(jsonNode, "tokenExpiration"), this.getUserOrString(jsonNode, "principal", jp), (Object)this.getCredentials(jsonNode, "credentials"), JsonSerdesUtil.readSet(jsonNode, "authorities", value -> new SimpleGrantedAuthority(JsonSerdesUtil.readString(value)))) : new ExpiringUsernameAuthenticationToken(this.getUserOrString(jsonNode, "principal", jp), (Object)this.getCredentials(jsonNode, "credentials"));
        Object details = this.getUserOrString(jsonNode, "details", jp);
        if (details != null) {
            token.setDetails(details);
        }
        return token;
    }

    @CheckForNull
    private Date getDate(@Nullable JsonNode jsonNode, String fieldName) {
        Long time = JsonSerdesUtil.readLong(jsonNode, fieldName);
        return time != null ? new Date(time) : null;
    }

    @CheckForNull
    private Object getUserOrString(@Nullable JsonNode jsonNode, String fieldName, JsonParser parser) throws IOException {
        User user = (User)JsonSerdesUtil.readObject(jsonNode, fieldName, parser);
        return user != null ? user : JsonSerdesUtil.readString(jsonNode, fieldName);
    }

    @CheckForNull
    private Serializable getCredentials(@Nullable JsonNode jsonNode, String fieldName) throws IOException {
        try {
            return JsonSerdesUtil.readSerializable(jsonNode, fieldName);
        }
        catch (ClassNotFoundException cnfe) {
            return JsonSerdesUtil.readString(jsonNode, fieldName);
        }
    }
}

