/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.kerberos.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;

public class KerberosServiceRequestTokenSerializer
extends JsonSerializer<KerberosServiceRequestToken> {
    public void serialize(KerberosServiceRequestToken token, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JsonSerdesUtil.writeBoolean(gen, "authenticated", token.isAuthenticated());
        JsonSerdesUtil.writeStringArray(gen, "authorities", token.getAuthorities(), a -> a.getAuthority());
        JsonSerdesUtil.writeObject(gen, "principal", token.getPrincipal());
        JsonSerdesUtil.writeBinary(gen, "token", token.getToken());
        Object details = token.getDetails();
        if (token.getPrincipal() != details) {
            JsonSerdesUtil.writeObject(gen, "details", details);
        }
    }

    public void serializeWithType(KerberosServiceRequestToken token, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)token, gen);
        this.serialize(token, gen, provider);
        typeSer.writeTypeSuffixForObject((Object)token, gen);
    }
}

