/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.kerberos.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;

@ParametersAreNonnullByDefault
public class KerberosServiceRequestTokenDeserializer
extends JsonDeserializer<KerberosServiceRequestToken> {
    public KerberosServiceRequestToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = JsonSerdesUtil.readTree(jp);
        if (jsonNode == null) {
            throw new IOException("Could not deserialize Kerberos request token. JSON is null.");
        }
        KerberosServiceRequestToken result = JsonSerdesUtil.readBooleanNonnull(jsonNode, "authenticated") ? new KerberosServiceRequestToken(this.getUserOrString(jsonNode, "principal", jp), null, JsonSerdesUtil.readSet(jsonNode, "authorities", value -> new SimpleGrantedAuthority(JsonSerdesUtil.readString(value))), JsonSerdesUtil.readBinaryNonnull(jsonNode, "token")) : new KerberosServiceRequestToken(JsonSerdesUtil.readBinaryNonnull(jsonNode, "token"));
        Object details = this.getUserOrString(jsonNode, "details", jp);
        if (details != null) {
            result.setDetails(details);
        }
        return result;
    }

    @CheckForNull
    private Object getUserOrString(JsonNode jsonNode, String fieldName, JsonParser parser) throws IOException {
        User user = (User)JsonSerdesUtil.readObject(jsonNode, fieldName, parser);
        return user != null ? user : JsonSerdesUtil.readString(jsonNode, fieldName);
    }
}

