/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.configuration;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.MultiHttpSessionStrategy;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@ParametersAreNonnullByDefault
public class JucoSessionConfiguration {
    private static final AntPathRequestMatcher SUPEROPERTY_CONFIG_PATH = new AntPathRequestMatcher("/config/**");

    @Nonnull
    @Bean(name={"cookieSerializer"})
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        cookieSerializer.setCookieName("JUST_SESSION");
        cookieSerializer.setCookiePath("/");
        return cookieSerializer;
    }

    @Nonnull
    @Bean(name={"justSessionRepositoryFilter"})
    public Filter justSessionRepositoryFilter(final @Qualifier(value="springSessionRepositoryFilter") Filter springSessionRepositoryFilter, ServletContext servletContext) {
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        cookieSerializer.setCookieName("JUST_ADMIN_SESSION");
        cookieSerializer.setCookiePath("/");
        CookieHttpSessionStrategy cookieHttpSessionStrategy = new CookieHttpSessionStrategy();
        cookieHttpSessionStrategy.setCookieSerializer((CookieSerializer)cookieSerializer);
        final SessionRepositoryFilter superopertySessionRepositoryFilter = new SessionRepositoryFilter((SessionRepository)new MapSessionRepository());
        superopertySessionRepositoryFilter.setServletContext(servletContext);
        superopertySessionRepositoryFilter.setHttpSessionStrategy((MultiHttpSessionStrategy)cookieHttpSessionStrategy);
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                SessionRepositoryFilter filter = SUPEROPERTY_CONFIG_PATH.matches(request) ? superopertySessionRepositoryFilter : springSessionRepositoryFilter;
                filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            }
        };
    }
}

