/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session;

import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"production"})
@ParametersAreNonnullByDefault
public class RedisHealthService {
    private final RedisConnectionFactory _redisConnectionFactory;

    @Autowired
    public RedisHealthService(@Qualifier(value="redisTomcatSessionClient") RedisConnectionFactory redisConnectionFactory) {
        this._redisConnectionFactory = redisConnectionFactory;
    }

    public void checkHealth() throws DataAccessException, RedisHealthException {
        RedisConnection connection = this._redisConnectionFactory.getConnection();
        try {
            String result = connection.ping();
            if (!result.equalsIgnoreCase("pong")) {
                throw new RedisHealthException("Unexpected ping result: " + result);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (DataAccessException dataAccessException) {}
            }
        }
    }

    public static class RedisHealthException
    extends RuntimeException {
        public RedisHealthException(String message) {
            super(message);
        }
    }
}

