/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.token.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import java.util.function.Function;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class OAuth2RequestSerializer
extends JsonSerializer<OAuth2Request> {
    public void serialize(OAuth2Request request, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JsonSerdesUtil.writeOptionalStringMap(gen, "requestParameters", request.getRequestParameters(), Function.identity(), Function.identity());
        JsonSerdesUtil.writeString(gen, "clientId", request.getClientId());
        JsonSerdesUtil.writeBoolean(gen, "approved", request.isApproved());
        JsonSerdesUtil.writeStringArray(gen, "scope", request.getScope(), Function.identity());
        JsonSerdesUtil.writeOptionalStringArray(gen, "authorities", request.getAuthorities(), a -> a.getAuthority());
        JsonSerdesUtil.writeOptionalString(gen, "redirectUri", request.getRedirectUri());
        JsonSerdesUtil.writeOptionalStringArray(gen, "resourceIds", request.getResourceIds(), Function.identity());
        JsonSerdesUtil.writeOptionalStringArray(gen, "responseTypes", request.getResponseTypes(), Function.identity());
        JsonSerdesUtil.writeOptionalSerializableMap(gen, "extensions", request.getExtensions(), Function.identity());
    }

    public void serializeWithType(OAuth2Request request, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)request, gen);
        this.serialize(request, gen, provider);
        typeSer.writeTypeSuffixForObject((Object)request, gen);
    }
}

