/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.model.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import de.justsoftware.jackson2.JsonSerdesUtil;
import de.justsoftware.onx.security.model.JustConnectUser;
import java.io.IOException;

public class JustConnectUserSerializer
extends JsonSerializer<JustConnectUser> {
    public void serialize(JustConnectUser user, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JsonSerdesUtil.writeLong(gen, "id", user.getId());
        JsonSerdesUtil.writeString(gen, "username", user.getUsername());
        JsonSerdesUtil.writeOptionalString(gen, "password", user.getPassword());
        JsonSerdesUtil.writeBoolean(gen, "accountNonExpired", user.isAccountNonExpired());
        JsonSerdesUtil.writeBoolean(gen, "accountNonLocked", user.isAccountNonLocked());
        JsonSerdesUtil.writeBoolean(gen, "credentialsNonExpired", user.isCredentialsNonExpired());
        JsonSerdesUtil.writeBoolean(gen, "enabled", user.isEnabled());
        JsonSerdesUtil.writeStringArray(gen, "authorities", user.getAuthorities(), a -> a.getAuthority());
    }

    public void serializeWithType(JustConnectUser user, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)user, gen);
        this.serialize(user, gen, provider);
        typeSer.writeTypeSuffixForObject((Object)user, gen);
    }
}

