/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.Assert;

@ParametersAreNonnullByDefault
public class JsonSerdesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSerdesUtil.class);

    @CheckForNull
    public static final JsonNode readTree(JsonParser parser) throws JsonProcessingException, IOException {
        return (JsonNode)((ObjectMapper)ObjectMapper.class.cast(parser.getCodec())).readTree(parser);
    }

    public static final void writeBoolean(JsonGenerator gen, String fieldName, boolean value) throws IOException {
        gen.writeBooleanField(fieldName, value);
    }

    @CheckForNull
    public static final Boolean readBoolean(@Nullable JsonNode jsonNode) {
        return jsonNode != null && !jsonNode.isNull() ? Boolean.valueOf(jsonNode.asBoolean()) : null;
    }

    public static final boolean readBooleanNonnull(@Nullable JsonNode jsonNode) {
        Boolean result = JsonSerdesUtil.readBoolean(jsonNode);
        Assert.notNull((Object)result, (String)("deserializer expected boolean value on node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final Boolean readBoolean(@Nullable JsonNode jsonNode, String fieldName) {
        return jsonNode != null && jsonNode.has(fieldName) ? JsonSerdesUtil.readBoolean(jsonNode.get(fieldName)) : null;
    }

    public static final boolean readBooleanNonnull(@Nullable JsonNode jsonNode, String fieldName) {
        Boolean result = JsonSerdesUtil.readBoolean(jsonNode, fieldName);
        Assert.notNull((Object)result, (String)("deserializer expected string boolean on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    public static final void writeLong(JsonGenerator gen, String fieldName, long value) throws IOException {
        gen.writeNumberField(fieldName, value);
    }

    @CheckForNull
    public static final Long readLong(@Nullable JsonNode jsonNode) {
        return jsonNode != null && !jsonNode.isNull() ? Long.valueOf(jsonNode.asLong()) : null;
    }

    public static final long readLongNonnull(@Nullable JsonNode jsonNode) {
        Long result = JsonSerdesUtil.readLong(jsonNode);
        Assert.notNull((Object)result, (String)("deserializer expected long value on node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final Long readLong(@Nullable JsonNode jsonNode, String fieldName) {
        return jsonNode != null && jsonNode.has(fieldName) ? JsonSerdesUtil.readLong(jsonNode.get(fieldName)) : null;
    }

    public static final long readLongNonnull(@Nullable JsonNode jsonNode, String fieldName) {
        Long result = JsonSerdesUtil.readLong(jsonNode, fieldName);
        Assert.notNull((Object)result, (String)("deserializer expected string long on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    public static void writeBinary(JsonGenerator gen, String fieldName, @Nullable byte[] value) throws IOException {
        gen.writeBinaryField(fieldName, value);
    }

    public static void writeOptionalBinary(JsonGenerator gen, String fieldName, @Nullable byte[] value) throws IOException {
        if (value != null) {
            JsonSerdesUtil.writeBinary(gen, fieldName, value);
        }
    }

    @CheckForNull
    public static final byte[] readBinary(@Nullable JsonNode jsonNode) throws IOException {
        return jsonNode != null && !jsonNode.isNull() ? jsonNode.binaryValue() : null;
    }

    @Nonnull
    public static final byte[] readBinaryNonnull(@Nullable JsonNode jsonNode) throws IOException {
        byte[] result = JsonSerdesUtil.readBinary(jsonNode);
        Assert.notNull((Object)result, (String)("deserializer expected binary value on node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final byte[] readBinary(@Nullable JsonNode jsonNode, String fieldName) throws IOException {
        return jsonNode != null && jsonNode.has(fieldName) ? JsonSerdesUtil.readBinary(jsonNode.get(fieldName)) : null;
    }

    @Nonnull
    public static final byte[] readBinaryNonnull(@Nullable JsonNode jsonNode, String fieldName) throws IOException {
        byte[] result = JsonSerdesUtil.readBinary(jsonNode, fieldName);
        Assert.notNull((Object)result, (String)("deserializer expected binary value on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    public static void writeString(JsonGenerator gen, String fieldName, @Nullable String value) throws IOException {
        gen.writeStringField(fieldName, value);
    }

    public static void writeOptionalString(JsonGenerator gen, String fieldName, @Nullable String value) throws IOException {
        if (value != null) {
            JsonSerdesUtil.writeString(gen, fieldName, value);
        }
    }

    @CheckForNull
    public static final String readString(@Nullable JsonNode jsonNode) {
        return jsonNode != null && !jsonNode.isNull() ? jsonNode.asText() : null;
    }

    @Nonnull
    public static final String readStringNonnull(@Nullable JsonNode jsonNode) {
        String result = JsonSerdesUtil.readString(jsonNode);
        Assert.hasText((String)result, (String)("deserializer expected string value on node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final String readString(@Nullable JsonNode jsonNode, String fieldName) {
        return jsonNode != null && jsonNode.has(fieldName) ? JsonSerdesUtil.readString(jsonNode.get(fieldName)) : null;
    }

    @Nonnull
    public static final String readStringNonnull(@Nullable JsonNode jsonNode, String fieldName) {
        String result = JsonSerdesUtil.readString(jsonNode, fieldName);
        Assert.hasText((String)result, (String)("deserializer expected string value on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final <T> T readObject(@Nullable JsonNode jsonNode, JsonParser jp) throws IOException {
        return (T)(jsonNode != null && !jsonNode.isNull() && jsonNode.isObject() ? jsonNode.traverse(jp.getCodec()).readValueAs(new TypeReference<T>(){}) : null);
    }

    @CheckForNull
    public static final <T> T readObject(@Nullable JsonNode jsonNode, String fieldName, JsonParser jp) throws IOException {
        return jsonNode != null && jsonNode.has(fieldName) ? (T)JsonSerdesUtil.readObject(jsonNode.get(fieldName), jp) : null;
    }

    @Nonnull
    public static final <T> T readObjectNonnull(@Nullable JsonNode jsonNode, String fieldName, JsonParser jp) throws IOException {
        T result = JsonSerdesUtil.readObject(jsonNode, fieldName, jp);
        Assert.notNull(result, (String)("deserializer expected json object on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    @CheckForNull
    public static final <T> T tryReadObject(@Nullable JsonNode jsonNode, String fieldName, JsonParser jp) {
        try {
            return JsonSerdesUtil.readObject(jsonNode, fieldName, jp);
        }
        catch (IOException e) {
            LOGGER.debug("ignored object parser exception: ", (Throwable)e);
            return null;
        }
    }

    public static void writeObject(JsonGenerator gen, String fieldName, @Nullable Object value) throws IOException {
        gen.writeObjectField(fieldName, value);
    }

    public static void writeOptionalObject(JsonGenerator gen, String fieldName, @Nullable Object value) throws IOException {
        if (value != null) {
            JsonSerdesUtil.writeObject(gen, fieldName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeSerializable(JsonGenerator gen, String fieldName, @Nullable Object value) throws IOException {
        try (ObjectOutputStream oos = null;){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            oos.close();
            gen.writeBinaryField(fieldName, Base64.encode((byte[])baos.toByteArray()));
        }
    }

    public static void writeOptionalSerializable(JsonGenerator gen, String fieldName, @Nullable Object value) throws IOException {
        if (value != null) {
            JsonSerdesUtil.writeSerializable(gen, fieldName, value);
        }
    }

    @CheckForNull
    public static final Serializable readSerializable(@Nullable JsonNode jsonNode) throws IOException, ClassNotFoundException {
        if (jsonNode != null && !jsonNode.isNull()) {
            try (ObjectInputStream ois = null;){
                ois = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((byte[])jsonNode.binaryValue())));
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }
        return null;
    }

    @CheckForNull
    public static final Serializable tryReadSerializable(@Nullable JsonNode jsonNode) {
        try {
            return JsonSerdesUtil.readSerializable(jsonNode);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.debug("ignored object parser exception: ", (Throwable)e);
            return null;
        }
    }

    @CheckForNull
    public static final Serializable readSerializable(@Nullable JsonNode jsonNode, String fieldName) throws IOException, ClassNotFoundException {
        return jsonNode != null && jsonNode.has(fieldName) ? JsonSerdesUtil.readSerializable(jsonNode.get(fieldName)) : null;
    }

    @CheckForNull
    public static final Serializable tryReadSerializable(@Nullable JsonNode jsonNode, String fieldName) {
        try {
            return JsonSerdesUtil.readSerializable(jsonNode, fieldName);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.debug("ignored object parser exception: ", (Throwable)e);
            return null;
        }
    }

    public static final <K, V> void writeStringMap(JsonGenerator gen, String fieldName, @Nullable Map<K, V> map, Function<K, String> keyMapper, Function<V, String> valueMapper) throws IOException {
        if (map != null && !map.isEmpty()) {
            gen.writeObjectFieldStart(fieldName);
            for (Map.Entry<K, V> entry : map.entrySet()) {
                String key = keyMapper.apply(entry.getKey());
                if (key == null) continue;
                JsonSerdesUtil.writeString(gen, key, valueMapper.apply(entry.getValue()));
            }
            gen.writeEndObject();
        } else {
            gen.writeNullField(fieldName);
        }
    }

    public static final <K, V> void writeOptionalStringMap(JsonGenerator gen, String fieldName, @Nullable Map<K, V> map, Function<K, String> keyMapper, Function<V, String> valueMapper) throws IOException {
        if (map != null && !map.isEmpty()) {
            JsonSerdesUtil.writeStringMap(gen, fieldName, map, keyMapper, valueMapper);
        }
    }

    public static final <K> void writeSerializableMap(JsonGenerator gen, String fieldName, @Nullable Map<K, ? extends Serializable> map, Function<K, String> keyMapper) throws IOException {
        if (map != null && !map.isEmpty()) {
            gen.writeObjectFieldStart(fieldName);
            for (Map.Entry<K, Serializable> entry : map.entrySet()) {
                String key = keyMapper.apply(entry.getKey());
                if (key == null) continue;
                JsonSerdesUtil.writeSerializable(gen, fieldName, entry.getValue());
            }
            gen.writeEndObject();
        } else {
            gen.writeNullField(fieldName);
        }
    }

    public static final <K, V> void writeOptionalSerializableMap(JsonGenerator gen, String fieldName, @Nullable Map<K, ? extends Serializable> map, Function<K, String> keyMapper) throws IOException {
        if (map != null && !map.isEmpty()) {
            JsonSerdesUtil.writeSerializableMap(gen, fieldName, map, keyMapper);
        }
    }

    @CheckForNull
    private static final <V> V mapNode(Function<JsonNode, V> valueMapper, @Nullable JsonNode valueNode) {
        return valueNode != null && !valueNode.isNull() ? (V)valueMapper.apply(valueNode) : null;
    }

    @CheckForNull
    public static final <K, V> Map<K, V> readMap(@Nullable JsonNode jsonNode, String fieldName, Function<String, K> keyMapper, Function<JsonNode, V> valueMapper) {
        if (jsonNode != null && jsonNode.has(fieldName)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            jsonNode.get(fieldName).fields().forEachRemaining(field -> {
                Object value;
                Object key = keyMapper.apply((String)field.getKey());
                Object v0 = value = key != null ? JsonSerdesUtil.mapNode(valueMapper, (JsonNode)field.getValue()) : null;
                if (value != null) {
                    builder.put(key, value);
                }
            });
            return builder.build();
        }
        return null;
    }

    @Nonnull
    public static final <K, V> Map<K, V> readMapNonnull(@Nullable JsonNode jsonNode, String fieldName, Function<String, K> keyMapper, Function<JsonNode, V> valueMapper) {
        Map<K, V> result = JsonSerdesUtil.readMap(jsonNode, fieldName, keyMapper, valueMapper);
        Assert.notNull(result, (String)("deserializer expected object on field " + fieldName + " of node " + jsonNode));
        return result;
    }

    public static final <V> void writeStringArray(JsonGenerator gen, String fieldName, @Nullable Iterable<V> values, Function<V, String> valueMapper) throws IOException {
        if (values != null) {
            gen.writeArrayFieldStart(fieldName);
            for (V value : values) {
                gen.writeString(valueMapper.apply(value));
            }
            gen.writeEndArray();
        } else {
            gen.writeNullField(fieldName);
        }
    }

    public static final <V> void writeOptionalStringArray(JsonGenerator gen, String fieldName, @Nullable Iterable<V> values, Function<V, String> valueMapper) throws IOException {
        if (values != null && !Iterables.isEmpty(values)) {
            JsonSerdesUtil.writeStringArray(gen, fieldName, values, valueMapper);
        }
    }

    @CheckForNull
    public static final <V> ImmutableSet<V> readSet(@Nullable JsonNode jsonNode, String fieldName, Function<JsonNode, V> valueMapper) {
        if (jsonNode != null && jsonNode.has(fieldName)) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            jsonNode.get(fieldName).elements().forEachRemaining(valueNode -> {
                Object value = JsonSerdesUtil.mapNode(valueMapper, valueNode);
                if (value != null) {
                    builder.add(value);
                }
            });
            return builder.build();
        }
        return null;
    }

    @Nonnull
    public static final <V> ImmutableSet<V> readSetNonnull(@Nullable JsonNode jsonNode, String fieldName, Function<JsonNode, V> valueMapper) {
        ImmutableSet<V> result = JsonSerdesUtil.readSet(jsonNode, fieldName, valueMapper);
        Assert.notNull(result, (String)("deserializer expected array on field " + fieldName + " of node " + jsonNode));
        return result;
    }
}

