/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.rest.permission;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.permission.business.AuthorizationResult;
import de.justsoftware.permission.business.InversePermissionResolver;
import de.justsoftware.permission.business.PermissionResolver;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.business.role.model.ApiRole;
import de.justsoftware.permission.business.role.model.SearchRole;
import de.justsoftware.permission.rest.BadRequestException;
import de.justsoftware.permission.rest.permission.PermissionController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(name="Permission")
@ParametersAreNonnullByDefault
public class PermissionController {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionController.class);
    private final ConsumerOffsetService _consumerOffsetService;
    private final PermissionResolver _permissionResolver;
    private final InversePermissionResolver _inversePermissionResolver;

    @Autowired
    public PermissionController(ConsumerOffsetService consumerOffsetService, PermissionResolver permissionResolver, InversePermissionResolver inversePermissionResolver) {
        this._consumerOffsetService = consumerOffsetService;
        this._permissionResolver = permissionResolver;
        this._inversePermissionResolver = inversePermissionResolver;
    }

    @Nonnull
    private static <K, V> Map<K, Set<V>> multimapToMap(Set<K> keys, SetMultimap<K, V> multimap) {
        return Maps.toMap(keys, arg_0 -> multimap.get(arg_0));
    }

    @Nonnull
    private static <T> Set<T> toSafeSet(@Nullable Set<T> value) {
        return Optional.ofNullable(value).map(s -> Sets.filter((Set)s, Objects::nonNull)).orElse((Set)ImmutableSet.of());
    }

    @GetMapping(value={"/error"})
    @Nonnull
    @Operation(description="tests error handling")
    public String error() {
        throw new IllegalArgumentException("FAIL!");
    }

    @GetMapping(value={"/consumerOffsets/waitFor/{topic}"})
    @Operation(description="Wait for the consumption of the given offset and partition in the given topic until timeout is reached. Returns whether the offset was consumed.")
    public boolean waitForConsumption(@PathVariable String topic, @RequestParam int partition, @RequestParam long offset, @RequestParam(defaultValue="1000") @Parameter(description="Timeout in ms to wait for consumption.") long timeout) {
        return this._consumerOffsetService.isConsumed(topic, partition, offset, timeout);
    }

    @PostMapping(value={"/consumerOffsets/waitFor"})
    @Operation(description="Wait for the consumption of the given offsets in the given topic-partitions until timeout is reached. Returns whether the offset was consumed.")
    public boolean waitForConsumption(@RequestBody WaitForConsumptionParams params) {
        return this._consumerOffsetService.isConsumed(params._offsets, params._timeout);
    }

    @GetMapping(value={"/has/{roleToResolve}"})
    @Nonnull
    @Operation(description="Returns OK if at least one of the given user roles has the requested role.")
    public AuthorizationResult has(@Parameter(name="A role which can be resolved: It should contain an item id or shouldn't need an item id. Therefore roles with wildcards are not allowed.") @PathVariable @Nullable ApiRole roleToResolve, @Parameter(name="Roles of the user. If asking for a user, you supply only its profile role. Not logged in users should supply an empty set. If you want to see an object in the view of a specific role, supply it here.") @RequestParam(required=false) @Nullable Set<SearchRole> userRoles) {
        ApiRole role = (ApiRole)BadRequestException.checkNotNull((Object)roleToResolve);
        return (AuthorizationResult)this._permissionResolver.resolve((Set)ImmutableSet.of((Object)role), PermissionController.toSafeSet(userRoles)).get((Object)role);
    }

    @PostMapping(value={"/has"})
    @Nonnull
    @Operation(description="Returns OK for each role if at least one of the given user roles has the requested role. (bulked version)")
    public Map<ApiRole, AuthorizationResult> has(@RequestBody HasParams params) {
        return this._permissionResolver.resolve(PermissionController.toSafeSet((Set)params._rolesToResolve), PermissionController.toSafeSet((Set)params._userRoles));
    }

    @GetMapping(value={"/visibility/{item}"})
    @Nonnull
    @Operation(description="Returns all roles which are allow to see the given item.")
    public Set<SearchRole> visibility(@PathVariable @Nullable ItemId item) {
        ItemId itemId = (ItemId)BadRequestException.checkNotNull((Object)item);
        return this._permissionResolver.visibility((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId);
    }

    @PostMapping(value={"/visibility"})
    @Nonnull
    @Operation(description="Returns all roles per item which are allowed to see the item. (bulked version)")
    public Map<ItemId, Set<SearchRole>> visibility(@RequestBody @Nullable @Parameter Set<ItemId> items) {
        Set itemIds = PermissionController.toSafeSet(items);
        LOG.debug("checking visibilitis for {} items", (Object)itemIds.size());
        return PermissionController.multimapToMap((Set)itemIds, (SetMultimap)this._permissionResolver.visibility(itemIds));
    }

    @GetMapping(value={"/searchRoles/{role}"})
    @Nonnull
    @Operation(description="Returns the search roles for the given role")
    public Set<SearchRole> searchRoles(@PathVariable @Nullable @Parameter SearchRole role) {
        SearchRole searchRole = (SearchRole)BadRequestException.checkNotNull((Object)role);
        return this._inversePermissionResolver.resolveToSearchRoles((Set)ImmutableSet.of((Object)searchRole)).get((Object)searchRole);
    }

    @PostMapping(value={"/searchRoles"})
    @Nonnull
    @Operation(description="Returns the search roles of the given roles (bulked version)")
    public Map<SearchRole, Set<SearchRole>> searchRoles(@RequestBody @ArraySchema(schema=@Schema(type="String")) @Nullable Set<SearchRole> roles) {
        Set searchRoles = PermissionController.toSafeSet(roles);
        return PermissionController.multimapToMap((Set)searchRoles, (SetMultimap)this._inversePermissionResolver.resolveToSearchRoles(searchRoles));
    }
}

