/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.rest.context;

import de.justsoftware.toolbox.performance.PerformanceLogger;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@ParametersAreNonnullByDefault
@ConditionalOnProperty(name={"performance.logging.enabled"})
public class PerformanceLoggerConfiguration {
    private static final int INFO_MILLIS = 50;
    private static final int WARN_MILLIS = 100;

    public PerformanceLoggerConfiguration() {
        PerformanceLogger.setPerformanceLoggerEnabled((boolean)true);
        PerformanceLogger.setThresholdTotalNanos((long)TimeUnit.MILLISECONDS.toNanos(50L));
        PerformanceLogger.setThresholdWarnNanos((long)TimeUnit.MILLISECONDS.toNanos(100L));
    }

    @Around(value="within(de.justsoftware..*) || within(org.springframework.jdbc.core.JdbcTemplate+)")
    public Object invokePerformanceLogger(ProceedingJoinPoint joinPoint) throws Throwable {
        return PerformanceLogger.logJoinPoint((ProceedingJoinPoint)joinPoint);
    }
}

