/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.h2;

import de.justsoftware.permission.persistence.DAOSupport;
import de.justsoftware.permission.persistence.NodeStateDAO;
import de.justsoftware.permission.persistence.RowMapper;
import de.justsoftware.toolbox.ObjectUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class H2NodeStateDAO
implements NodeStateDAO {
    private final DAOSupport _daoSupport;

    @Autowired
    public H2NodeStateDAO(DAOSupport daoSupport) {
        this._daoSupport = daoSupport;
    }

    public String getValue(String key) {
        return (String)this._daoSupport.prep().append("SELECT value_col FROM node_state WHERE key_col = ?", new Object[]{key}).singleObject(RowMapper.stringCol((String)"value_col"));
    }

    public void setValue(String key, String value) {
        this._daoSupport.prep().append("MERGE INTO node_state(key_col, value_col, mtime)", new Object[0]).append("VALUES (?, ?, now())", new Object[]{key, value}).update();
    }

    public String getValueOrStoreDefault(String key, String defaultValue) {
        this._daoSupport.prep().append("INSERT INTO node_state(key_col, value_col)", new Object[0]).append("SELECT ?,? WHERE NOT EXISTS (SELECT 1 FROM node_state WHERE key_col = ?)", new Object[]{key, defaultValue, key}).update();
        return (String)ObjectUtil.checkNotNull((Object)this.getValue(key));
    }
}

