/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.business.role.RoleService;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.kafka.AbstractKafkaConsumer;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.persistence.TransactionSupport;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class SingleRoleConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.permission.singleRoleAssignment";
    private static final Logger LOG = LoggerFactory.getLogger(SingleRoleConsumer.class);
    private final RoleService _roleService;

    @Autowired
    public SingleRoleConsumer(KafkaConfigurationProvider configurationProvider, RoleService roleService, ConsumerOffsetService consumerOffsetService, TransactionSupport transactionSupport) {
        this(() -> configurationProvider.stringConsumer("just.permission.SingleRoleConsumer-" + configurationProvider.getKafkaGroupIdentifier()), roleService, consumerOffsetService, configurationProvider, transactionSupport);
    }

    @VisibleForTesting
    SingleRoleConsumer(Supplier<Consumer<String, String>> consumerSupplier, RoleService roleService, ConsumerOffsetService consumerOffsetService, KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport) {
        super(consumerSupplier, TOPIC, 0, consumerOffsetService, configurationProvider, transactionSupport);
        this._roleService = roleService;
    }

    protected Logger getLog() {
        return LOG;
    }

    protected void process(ConsumerRecords<String, String> records) {
        HashBasedTable consumed = HashBasedTable.create();
        records.forEach(arg_0 -> this.lambda$process$1((Table)consumed, arg_0));
        this._roleService.storeRoleReplacements((Table)consumed);
    }

    private void consumeRecord(Table<DirectlyResolvableRole, Role, Optional<Boolean>> consumed, ConsumerRecord<String, String> record) {
        try {
            String key = (String)record.key();
            int semicolon = key.indexOf(59);
            if (semicolon < 0) {
                LOG.warn("record key does not contain a semicolon: {}", record);
                return;
            }
            String r = key.substring(0, semicolon);
            Role from = Role.valueOf((String)r);
            if (!(from instanceof DirectlyResolvableRole)) {
                LOG.warn("first part of record key is not a resolvable role: {}", record);
                return;
            }
            Role to = Role.valueOf((String)key.substring(semicolon + 1));
            consumed.put((Object)((DirectlyResolvableRole)from), (Object)to, (Object)this.parseValue((String)record.value()));
        }
        catch (RuntimeException e) {
            LOG.warn("runtime exception during parsing record: {}", record);
        }
    }

    @Nonnull
    private Optional<Boolean> parseValue(String value) {
        String t = StringUtils.trimToNull((String)value);
        if (t == null) {
            return Optional.empty();
        }
        return Optional.of(t.charAt(0) != 'f');
    }

    private /* synthetic */ void lambda$process$1(Table consumed, ConsumerRecord record) {
        this.consumeRecord(consumed, record);
    }
}

