/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.permission.business.item.ItemService;
import de.justsoftware.permission.business.item.model.Item;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.kafka.AbstractKafkaConsumer;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.persistence.TransactionSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ParametersAreNonnullByDefault
public class ItemConsumer
extends AbstractKafkaConsumer<String, String> {
    public static final String TOPIC = "just.permission.item";
    private static final Logger LOG = LoggerFactory.getLogger(ItemConsumer.class);
    private final ItemService _itemService;

    @VisibleForTesting
    ItemConsumer(Supplier<Consumer<String, String>> consumerSupplier, ItemService itemService, ConsumerOffsetService consumerOffsetService, KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport) {
        super(consumerSupplier, "just.permission.item", 0, consumerOffsetService, configurationProvider, transactionSupport);
        this._itemService = itemService;
    }

    @Autowired
    public ItemConsumer(KafkaConfigurationProvider configurationProvider, ItemService itemService, ConsumerOffsetService consumerOffsetService, TransactionSupport transactionSupport) {
        this(() -> configurationProvider.stringConsumer("just.permission.ItemConsumer-" + configurationProvider.getKafkaGroupIdentifier()), itemService, consumerOffsetService, configurationProvider, transactionSupport);
    }

    protected Logger getLog() {
        return LOG;
    }

    protected void process(ConsumerRecords<String, String> records) throws AbstractKafkaConsumer.StopProcessingException {
        HashSet deletes = new HashSet();
        HashMap items = new HashMap();
        records.forEach(record -> this.consumeRecord(record, deletes, items));
        this._itemService.deleteItems(deletes);
        this._itemService.storeItems((List)ImmutableList.copyOf(items.values()));
    }

    private void consumeRecord(ConsumerRecord<String, String> record, HashSet<ItemId> deleteBuilder, HashMap<ItemId, Item> items) {
        try {
            String key = (String)record.key();
            if (key == null) {
                return;
            }
            ItemId itemId = ItemId.valueOf((String)key);
            String value = (String)record.value();
            if (value == null) {
                deleteBuilder.add(itemId);
                items.remove(itemId);
                return;
            }
            JsonNode json = this.parseJson(value);
            if (json == null) {
                return;
            }
            ItemId optionalParentId = ItemConsumer.parseString((JsonNode)json, (String)"parent").map(ItemId::valueOf).orElse(null);
            ImmutableSet.Builder itemParams = ImmutableSet.builder();
            JsonNode paramsNode = json.get("params");
            if (paramsNode != null) {
                paramsNode.forEach(param -> itemParams.add((Object)param.asText()));
            }
            items.put(itemId, new Item(itemId, optionalParentId, (Set)itemParams.build()));
            deleteBuilder.remove(itemId);
        }
        catch (RuntimeException e) {
            LOG.warn("runtime exception during parsing record: {}", record);
        }
    }
}

