/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.item.model;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class ItemType
extends AbstractImmutableEqualsObject {
    public static final long TOTAL_EXPECTED = 100L;
    private static final Logger LOG = LoggerFactory.getLogger(ItemType.class);
    private static final LoadingCache<String, ItemType> CACHE = CacheBuilder.newBuilder().maximumSize(100L).removalListener(notification -> {
        if (notification.wasEvicted()) {
            LOG.warn("unexpected removal from cache: {} {}", (Object)notification.getCause(), (Object)notification);
        }
    }).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final String _itemType;

    private ItemType(String itemType) {
        super(new Object[]{itemType});
        this._itemType = itemType;
    }

    @Nonnull
    public static ItemType get(String key) {
        String t = ((String)Preconditions.checkNotNull((Object)key)).trim();
        if (t.isEmpty()) {
            throw new IllegalArgumentException("empty item type is not allowed");
        }
        return (ItemType)CACHE.getUnchecked((Object)key);
    }

    @Nonnull
    public String asString() {
        return this._itemType;
    }

    public String toString() {
        return this._itemType;
    }
}

