/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.config.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Replacement
extends AbstractImmutableEqualsObject {
    public static final Replacement EMPTY = new Replacement(ImmutableSet.of(), ImmutableSet.of());
    private final ImmutableSet<Role> _allowed;
    private final ImmutableSet<Role> _forbidden;

    public Replacement(Set<? extends Role> allowed, Set<? extends Role> forbidden) {
        this(ImmutableSet.copyOf((Collection)Sets.difference(allowed, forbidden)), ImmutableSet.copyOf(forbidden));
    }

    private Replacement(ImmutableSet<Role> allowed, ImmutableSet<Role> forbidden) {
        super(new Object[]{allowed, forbidden});
        this._allowed = allowed;
        this._forbidden = forbidden;
    }

    @Nonnull
    public ImmutableSet<Role> getAllowed() {
        return this._allowed;
    }

    @Nonnull
    public ImmutableSet<Role> getForbidden() {
        return this._forbidden;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allowed", (Object)this._allowed).add("forbidden", (Object)this._forbidden).toString();
    }

    @Nonnull
    public Replacement union(Replacement other) {
        return new Replacement((Set)Sets.union((Set)this._allowed, (Set)other._allowed), (Set)Sets.union((Set)this._forbidden, (Set)other._forbidden));
    }
}

