/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.domain.newscover.NewsCover;
import de.justsoftware.news.json.ItemIdDeserializer;
import de.justsoftware.news.json.UserIdDeserializer;
import de.justsoftware.news.kafka.toromigration.ChannelKafkaDto;
import de.justsoftware.news.kafka.toromigration.ChannelMigrationService;
import de.justsoftware.news.kafka.toromigration.KafkaToroMigrationConsumer;
import de.justsoftware.news.kafka.toromigration.NewsCoverMigrationService;
import de.justsoftware.news.kafka.toromigration.PostMigrationKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0017J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0012J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0012J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/news/kafka/toromigration/KafkaToroMigrationConsumer;", "", "channelMigrationService", "Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;", "postMigrationService", "Lde/justsoftware/news/kafka/toromigration/PostMigrationService;", "newsCoverMigrationService", "Lde/justsoftware/news/kafka/toromigration/NewsCoverMigrationService;", "(Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;Lde/justsoftware/news/kafka/toromigration/PostMigrationService;Lde/justsoftware/news/kafka/toromigration/NewsCoverMigrationService;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "listen", "", "key", "", "payload", "parseChannel", "Lde/justsoftware/news/kafka/toromigration/ChannelKafkaDto;", "parseNewsCover", "Lde/justsoftware/news/domain/newscover/NewsCover;", "parsePost", "Lde/justsoftware/news/kafka/toromigration/PostMigrationKafkaDto;", "Companion", "news-service"})
public class KafkaToroMigrationConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelMigrationService channelMigrationService;
    @NotNull
    private final PostMigrationService postMigrationService;
    @NotNull
    private final NewsCoverMigrationService newsCoverMigrationService;
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;

    public KafkaToroMigrationConsumer(@NotNull ChannelMigrationService channelMigrationService, @NotNull PostMigrationService postMigrationService, @NotNull NewsCoverMigrationService newsCoverMigrationService) {
        Intrinsics.checkNotNullParameter((Object)channelMigrationService, (String)"channelMigrationService");
        Intrinsics.checkNotNullParameter((Object)postMigrationService, (String)"postMigrationService");
        Intrinsics.checkNotNullParameter((Object)newsCoverMigrationService, (String)"newsCoverMigrationService");
        this.channelMigrationService = channelMigrationService;
        this.postMigrationService = postMigrationService;
        this.newsCoverMigrationService = newsCoverMigrationService;
        Module[] moduleArray = new Module[]{(Module)UserIdDeserializer.INSTANCE, (Module)ItemIdDeserializer.INSTANCE};
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(moduleArray);
    }

    @KafkaListener(containerFactory="toroMigrationListenerContainerFactory", topics={"just.toro.migration.news"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable String payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (ChannelId.Companion.isValid(key)) {
            ChannelKafkaDto channelDto;
            ChannelKafkaDto channelKafkaDto = channelDto = this.parseChannel(payload);
            if (channelKafkaDto != null) {
                ChannelKafkaDto it = channelKafkaDto;
                boolean bl = false;
                this.channelMigrationService.migrateChannel(channelDto);
            }
        } else if (PostId.Companion.isValid(key)) {
            PostMigrationKafkaDto postDto;
            PostMigrationKafkaDto postMigrationKafkaDto = postDto = this.parsePost(payload);
            if (postMigrationKafkaDto != null) {
                PostMigrationKafkaDto it = postMigrationKafkaDto;
                boolean bl = false;
                this.postMigrationService.migratePost(postDto);
            }
        } else if (TenantId.Companion.isValid(key)) {
            NewsCover newsCover;
            NewsCover newsCover2 = newsCover = this.parseNewsCover(payload);
            if (newsCover2 != null) {
                NewsCover it = newsCover2;
                boolean bl = false;
                this.newsCoverMigrationService.migrate(newsCover);
            }
        } else {
            log.warn("Skipping message because key: '" + key + "' is not a ChannelId, PostId or TenantId.");
        }
    }

    private ChannelKafkaDto parseChannel(String payload) {
        ChannelKafkaDto channelKafkaDto;
        try {
            channelKafkaDto = (ChannelKafkaDto)this.objectMapper.readValue(payload, ChannelKafkaDto.class);
        }
        catch (Exception e) {
            log.warn("Failed to deserialize payload: '" + payload + "' to Channel.");
            channelKafkaDto = null;
        }
        return channelKafkaDto;
    }

    private PostMigrationKafkaDto parsePost(String payload) {
        PostMigrationKafkaDto postMigrationKafkaDto;
        try {
            postMigrationKafkaDto = (PostMigrationKafkaDto)this.objectMapper.readValue(payload, PostMigrationKafkaDto.class);
        }
        catch (Exception e) {
            log.warn("Failed to deserialize payload: '" + payload + "' to Post.");
            postMigrationKafkaDto = null;
        }
        return postMigrationKafkaDto;
    }

    private NewsCover parseNewsCover(String payload) {
        NewsCover newsCover;
        try {
            newsCover = (NewsCover)this.objectMapper.readValue(payload, NewsCover.class);
        }
        catch (Exception e) {
            log.warn("Failed to deserialize payload: '" + payload + "' to NewsCover.");
            newsCover = null;
        }
        return newsCover;
    }

    static {
        Logger logger = LoggerFactory.getLogger(KafkaToroMigrationConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KafkaToroMigrationConsumer::class.java)");
        log = logger;
    }
}

