/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import de.justsoftware.news.kafka.KafkaConsumerConfiguration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@Configuration
@EnableKafka
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0012J\u001a\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/kafka/toromigration/KafkaToroMigrationConfiguration;", "", "kafkaConsumerConfiguration", "Lde/justsoftware/news/kafka/KafkaConsumerConfiguration;", "(Lde/justsoftware/news/kafka/KafkaConsumerConfiguration;)V", "consumerConfig", "", "", "toroMigrationListenerContainerFactory", "Lorg/springframework/kafka/config/KafkaListenerContainerFactory;", "Lorg/springframework/kafka/listener/ConcurrentMessageListenerContainer;", "news-service"})
public class KafkaToroMigrationConfiguration {
    @NotNull
    private final KafkaConsumerConfiguration kafkaConsumerConfiguration;

    public KafkaToroMigrationConfiguration(@NotNull KafkaConsumerConfiguration kafkaConsumerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerConfiguration, (String)"kafkaConsumerConfiguration");
        this.kafkaConsumerConfiguration = kafkaConsumerConfiguration;
    }

    @Bean
    @NotNull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> toroMigrationListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(this.consumerConfig()));
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)new FixedBackOff(1000L, 1L)));
        return (KafkaListenerContainerFactory)factory;
    }

    private Map<String, Object> consumerConfig() {
        Map props = this.kafkaConsumerConfiguration.defaultConsumerConfig();
        props.put("group.id", "just.toro.migration.news");
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        return props;
    }
}

