/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.kafka.toromigration.ChannelKafkaDto;
import de.justsoftware.news.kafka.toromigration.ChannelMigrationService;
import de.justsoftware.news.kafka.toromigration.ChannelPermissionKafkaDto;
import de.justsoftware.news.kafka.toromigration.PersonalSubscriptionKafkaDto;
import de.justsoftware.news.util.TransactionSupport;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "migrateChannel", "", "channelKafkaDto", "Lde/justsoftware/news/kafka/toromigration/ChannelKafkaDto;", "Companion", "news-service"})
public class ChannelMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private static final Logger log;

    public ChannelMigrationService(@NotNull ChannelRepo channelRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.channelRepo = channelRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migrateChannel(@NotNull ChannelKafkaDto channelKafkaDto) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)channelKafkaDto, (String)"channelKafkaDto");
        ChannelId id = channelKafkaDto.component1();
        String title = channelKafkaDto.component2();
        TenantId tenantId = channelKafkaDto.component3();
        long createDate = channelKafkaDto.component4();
        long modifyDate = channelKafkaDto.component5();
        List permissions = channelKafkaDto.component6();
        List subscriptions = channelKafkaDto.component7();
        if (this.channelRepo.findById((Object)id).isPresent()) {
            log.info("Skipping migration. Channel {} already migrated", (Object)id);
            return;
        }
        Instant instant = Instant.ofEpochSecond(modifyDate);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(modifyDate)");
        Instant instant2 = Instant.ofEpochSecond(createDate);
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(createDate)");
        ChannelRepo.insert$default((ChannelRepo)this.channelRepo, (ChannelId)id, (String)title, (TenantId)tenantId, (Instant)instant, (Instant)instant2, (boolean)false, (int)32, null);
        Channel channel = this.channelRepo.getByIdAndDeletedFalse(id);
        Iterable $this$map$iv = permissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelPermissionKafkaDto channelPermissionKafkaDto = (ChannelPermissionKafkaDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.channelPermissionRepo.insert(it.getId(), channel.getId(), it.getGranteeId(), it.getRole());
            collection.add(new PermissionItem((ItemId)channel.getId(), it.getGranteeId(), it.getRole()));
        }
        List permissionItems = (List)destination$iv$iv;
        Iterable $this$forEach$iv = subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersonalSubscriptionKafkaDto it = (PersonalSubscriptionKafkaDto)element$iv;
            boolean bl = false;
            this.personalSubscriptionRepo.insert(it.getId(), channel.getId(), it.getProfileId(), it.getNotificationsEnabled(), it.getUserHasUnsubscribed());
        }
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(ChannelMigrationService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(ChannelMigrationService $this) {
        return $this.eventPublisher;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ChannelMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ChannelMigrationService::class.java)");
        log = logger;
    }
}

