/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.search;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.SearchableItemId;
import de.justsoftware.news.connector.search.SearchConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.kafka.search.SearchIndexConsumer;
import de.justsoftware.news.kafka.search.SearchIndexType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\u001c\b\u0001\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r0\fH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/kafka/search/SearchIndexConsumer;", "", "searchConnector", "Lde/justsoftware/news/connector/search/SearchConnector;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "(Lde/justsoftware/news/connector/search/SearchConnector;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;)V", "listen", "", "records", "", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "Lde/justsoftware/news/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "Companion", "news-service"})
public class SearchIndexConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchConnector searchConnector;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private static final Logger LOG;

    public SearchIndexConsumer(@NotNull SearchConnector searchConnector, @NotNull PostRepo postRepo, @NotNull ChannelRepo channelRepo) {
        Intrinsics.checkNotNullParameter((Object)searchConnector, (String)"searchConnector");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        this.searchConnector = searchConnector;
        this.postRepo = postRepo;
        this.channelRepo = channelRepo;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(containerFactory="searchIndexListenerContainerFactory", topics={"just.news.searchIndexQueue"}, groupId="just.news-service.searchIndexConsumer")
    public void listen(@Payload(required=true) @NotNull List<? extends ConsumerRecord<SearchableItemId, SearchIndexType>> records) {
        void $this$associateByTo$iv$iv;
        void $this$associateByTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        PostId it;
        Iterable $this$associateByTo$iv$iv3;
        void $this$filterTo$iv$iv2;
        Object it2;
        Map map;
        Iterable $this$associateByTo$iv$iv4;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.searchConnector.ping();
        HashSet<SearchableItemId> postIds = new HashSet<SearchableItemId>();
        HashSet<SearchableItemId> channelIds = new HashSet<SearchableItemId>();
        HashSet<SearchableItemId> updatedPermissions = new HashSet<SearchableItemId>();
        LOG.info("processing " + records.size() + " records");
        Iterable $this$forEach$iv = records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            SearchIndexType indexType = (SearchIndexType)record.value();
            SearchableItemId key = (SearchableItemId)record.key();
            if (key instanceof ChannelId) {
                channelIds.add(key);
                if (indexType != SearchIndexType.PERMISSIONS) continue;
                updatedPermissions.add(key);
                continue;
            }
            if (!(key instanceof PostId)) continue;
            postIds.add(key);
        }
        StopWatch stopWatch = new StopWatch("indexing");
        stopWatch.start("loading " + channelIds.size() + " channels");
        Iterable $this$associateBy$iv = this.channelRepo.findByIdInAndDeletedFalse((Set)channelIds);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable bl = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv4) {
            Channel channel = (Channel)element$iv$iv;
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it2.getId(), element$iv$iv);
        }
        Map channelIdToChannelMap = destination$iv$iv;
        Iterable $this$filter$iv = channelIds;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv4 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (ChannelId)element$iv$iv;
            boolean bl3 = false;
            if (!(!channelIdToChannelMap.containsKey(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set channelIdsToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        stopWatch.stop();
        stopWatch.start("loading " + postIds.size() + " posts");
        Iterable $this$associateBy$iv2 = this.postRepo.findByIdInAndDeletedFalse((Set)postIds);
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable $i$f$filterTo22 = $this$associateBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv3) {
            Post post = (Post)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl4 = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map postIdToPostMap = destination$iv$iv2;
        Iterable $this$filter$iv2 = postIds;
        boolean $i$f$filter2 = false;
        $this$associateByTo$iv$iv3 = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PostId)element$iv$iv;
            boolean bl5 = false;
            if (!(!postIdToPostMap.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set postIdsToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set postsFromUpdatedChannels = this.postRepo.findByChannelIdInAndDeletedFalse((Set)updatedPermissions);
        Set postsToIndex = CollectionsKt.toSet((Iterable)CollectionsKt.union((Iterable)CollectionsKt.toSet((Iterable)postIdToPostMap.values()), (Iterable)postsFromUpdatedChannels));
        destination$iv$iv2 = postsToIndex;
        map = this.channelRepo;
        boolean $i$f$map = false;
        it2 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Post post = (Post)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add(it3.getChannelId());
        }
        Iterable $this$associateBy$iv3 = map.getByIdInAndDeletedFalse(CollectionsKt.toSet((Iterable)((List)destination$iv$iv3)));
        boolean $i$f$associateBy3 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv3, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv3;
        Object destination$iv$iv4 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it4;
            Channel bl6 = (Channel)element$iv$iv;
            map = destination$iv$iv4;
            boolean bl7 = false;
            map.put(it4.getId(), element$iv$iv);
        }
        Map chanelMapForPosts = destination$iv$iv4;
        Iterable $this$associateBy$iv4 = postsToIndex;
        boolean $i$f$associateBy4 = false;
        int capacity$iv4 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv4, (int)10)), (int)16);
        destination$iv$iv4 = $this$associateBy$iv4;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv4);
        boolean $i$f$associateByTo4 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Post bl7 = (Post)element$iv$iv;
            map = destination$iv$iv5;
            boolean bl8 = false;
            Post it5 = (Post)element$iv$iv;
            collection = it5.getId();
            boolean bl9 = false;
            Channel channel = (Channel)chanelMapForPosts.get(it5.getChannelId());
            map.put(collection, channel);
        }
        Map postIdToChannelMap = destination$iv$iv5;
        stopWatch.stop();
        stopWatch.start("sending data to solr");
        this.searchConnector.delete((Collection)postIdsToDelete);
        this.searchConnector.deleteChannels((Collection)channelIdsToDelete);
        this.searchConnector.upsertChannels(CollectionsKt.toSet((Iterable)channelIdToChannelMap.values()));
        this.searchConnector.upsert(postsToIndex, postIdToChannelMap);
        stopWatch.stop();
        LOG.info(stopWatch.prettyPrint());
    }

    static {
        Logger logger = LoggerFactory.getLogger(SearchIndexConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SearchIndexConsumer::class.java)");
        LOG = logger;
    }
}

