/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.drive;

import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.events.PostCreatedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.kafka.drive.DriveCreateItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/kafka/drive/KafkaDriveItemProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "", "(Lorg/apache/kafka/clients/producer/KafkaProducer;)V", "deleteAllAttachments", "", "event", "Lde/justsoftware/news/events/PostDeletedEvent;", "publishPostItem", "post", "Lde/justsoftware/news/domain/post/Post;", "Lde/justsoftware/news/events/PostCreatedEvent;", "news-service"})
public class KafkaDriveItemProducer {
    @NotNull
    private final KafkaProducer<String, String> producer;

    public KafkaDriveItemProducer(@NotNull KafkaProducer<String, String> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this.producer = producer;
    }

    @Async
    @EventListener
    public void publishPostItem(@NotNull PostCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String value = new DriveCreateItem(event.getChannelId().toTypedString()).toJsonString();
        this.producer.send(new ProducerRecord("just.items", (Object)event.getPostId().toTypedString(), (Object)value));
    }

    public void publishPostItem(@NotNull Post post) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        String value = new DriveCreateItem(post.getChannelId().toTypedString()).toJsonString();
        this.producer.send(new ProducerRecord("just.items", (Object)post.getId().toTypedString(), (Object)value));
    }

    @Async
    @EventListener
    public void deleteAllAttachments(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.items", (Object)event.getPostId().toTypedString(), null));
    }
}

