/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.user;

import de.justsoftware.news.ProfileId;
import de.justsoftware.news.UserGroupId;
import de.justsoftware.news.UserGroupMemberId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.domain.user.User;
import de.justsoftware.news.domain.user.UserGroup;
import de.justsoftware.news.domain.user.UserGroupMember;
import de.justsoftware.news.domain.user.UserGroupMemberRepo;
import de.justsoftware.news.domain.user.UserGroupRepo;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.GroupMembersDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0017J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0017J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0017J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001cH\u0017J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0017H\u0017J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u001fH\u0017J\u0016\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/news/domain/user/UserService;", "", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "userGroupRepo", "Lde/justsoftware/news/domain/user/UserGroupRepo;", "userGroupMemberRepo", "Lde/justsoftware/news/domain/user/UserGroupMemberRepo;", "(Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/user/UserGroupRepo;Lde/justsoftware/news/domain/user/UserGroupMemberRepo;)V", "deleteProfile", "", "profileId", "Lde/justsoftware/news/ProfileId;", "deleteUserGroup", "userGroupId", "Lde/justsoftware/news/UserGroupId;", "deleteUserGroupMembers", "userGroupMemberIds", "", "Lde/justsoftware/news/UserGroupMemberId;", "findProfile", "Lde/justsoftware/news/domain/user/Profile;", "id", "findProfileIdsOfGroup", "", "findProfilesByIds", "", "profileIds", "findUserGroup", "Lde/justsoftware/news/domain/user/UserGroup;", "findUsersByIds", "Lde/justsoftware/news/domain/user/User;", "userIds", "Lde/justsoftware/news/UserId;", "upsertProfile", "profile", "upsertUserGroup", "userGroup", "upsertUserGroupMembers", "userGroupMembers", "Lde/justsoftware/news/domain/user/UserGroupMember;", "news-service"})
public class UserService {
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final UserGroupRepo userGroupRepo;
    @NotNull
    private final UserGroupMemberRepo userGroupMemberRepo;

    public UserService(@NotNull ApplicationEventPublisher eventPublisher, @NotNull ProfileRepo profileRepo, @NotNull UserGroupRepo userGroupRepo, @NotNull UserGroupMemberRepo userGroupMemberRepo) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupRepo, (String)"userGroupRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepo, (String)"userGroupMemberRepo");
        this.eventPublisher = eventPublisher;
        this.profileRepo = profileRepo;
        this.userGroupRepo = userGroupRepo;
        this.userGroupMemberRepo = userGroupMemberRepo;
    }

    @Unauthorized
    public void upsertProfile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileRepo.findById((Object)profile.getId()).ifPresentOrElse(arg_0 -> UserService.upsertProfile$lambda-0(this, profile, arg_0), () -> UserService.upsertProfile$lambda-1(this, profile));
    }

    @Unauthorized
    public void upsertUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.userGroupRepo.findById((Object)userGroup.getId()).ifPresentOrElse(arg_0 -> UserService.upsertUserGroup$lambda-2(this, userGroup, arg_0), () -> UserService.upsertUserGroup$lambda-3(this, userGroup));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @Transactional
    public void upsertUserGroupMembers(@NotNull Collection<UserGroupMember> userGroupMembers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupMembers, (String)"userGroupMembers");
        Iterable iterable = userGroupMembers;
        UserGroupMemberRepo userGroupMemberRepo = this.userGroupMemberRepo;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable iterable2 = userGroupMemberRepo.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"userGroupMemberRepo.find\u2026oupMembers.map { it.id })");
        Set updates = CollectionsKt.toSet((Iterable)iterable2);
        this.userGroupMemberRepo.saveAll((Iterable)updates);
        Iterable $this$forEach$iv = CollectionsKt.subtract((Iterable)userGroupMembers, (Iterable)updates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupMember it = (UserGroupMember)element$iv;
            boolean bl = false;
            this.userGroupMemberRepo.insert(it.getId(), it.getUserGroupId(), it.getProfileId());
        }
    }

    @Unauthorized
    @Nullable
    public UserGroup findUserGroup(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (UserGroup)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.userGroupRepo), (Object)id);
    }

    @Unauthorized
    @Nullable
    public Profile findProfile(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Profile)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.profileRepo), (Object)id);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Set<ProfileId> findProfileIdsOfGroup(@NotNull UserGroupId userGroupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Iterable $this$map$iv = this.userGroupMemberRepo.getByUserGroupId(userGroupId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfileId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Unauthorized
    @NotNull
    public List<Profile> findProfilesByIds(@NotNull List<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = this.profileRepo.findAllById((Iterable)profileIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"profileRepo\n            .findAllById(profileIds)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<User> findUsersByIds(@NotNull List<? extends UserId> userIds) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable iterable = userIds;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable userGroupIds = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.userGroupRepo.findAllById(userGroupIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"userIds\n            .fil\u2026ndAllById(userGroupIds) }");
        Iterable userGroups = iterable2;
        userGroupIds = userIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List profileIds = (List)destination$iv$iv2;
        boolean bl2 = false;
        Iterable iterable3 = this.profileRepo.findAllById((Iterable)profileIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"userIds\n            .fil\u2026findAllById(profileIds) }");
        Iterable profiles = iterable3;
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Iterable)userGroups, (Iterable)profiles);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @Unauthorized
    @Transactional
    public void deleteProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileRepo.markAsDeleted(profileId);
        this.eventPublisher.publishEvent((ApplicationEvent)new ProfileDeletedEvent(profileId));
    }

    @Unauthorized
    @Transactional
    public void deleteUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        this.userGroupRepo.deleteById((Object)userGroupId);
        this.eventPublisher.publishEvent((ApplicationEvent)new GroupDeletedEvent(userGroupId));
    }

    @Unauthorized
    @Transactional
    public void deleteUserGroupMembers(@NotNull Collection<UserGroupMemberId> userGroupMemberIds) {
        Intrinsics.checkNotNullParameter(userGroupMemberIds, (String)"userGroupMemberIds");
        this.userGroupMemberRepo.deleteAllById((Iterable)userGroupMemberIds);
        this.eventPublisher.publishEvent((ApplicationEvent)new GroupMembersDeletedEvent(userGroupMemberIds));
    }

    private static final void upsertProfile$lambda-0(UserService this$0, Profile $profile, Profile it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$profile, (String)"$profile");
        this$0.profileRepo.save((Object)$profile);
    }

    private static final void upsertProfile$lambda-1(UserService this$0, Profile $profile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$profile, (String)"$profile");
        this$0.profileRepo.insert($profile.getId(), $profile.getFirstName(), $profile.getLastName(), $profile.getEmail(), $profile.getImageUrl(), $profile.getStatus());
    }

    private static final void upsertUserGroup$lambda-2(UserService this$0, UserGroup $userGroup, UserGroup it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroup, (String)"$userGroup");
        this$0.userGroupRepo.save((Object)$userGroup);
    }

    private static final void upsertUserGroup$lambda-3(UserService this$0, UserGroup $userGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroup, (String)"$userGroup");
        this$0.userGroupRepo.insert($userGroup.getId(), $userGroup.getName(), $userGroup.getTenantId());
    }
}

